/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static <T> TensorSummary create(Scope scope, Operand<T> tensor, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TensorSummary", scope.makeOpName("TensorSummary"));
        operationBuilder.addInput(tensor.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.description != null) {
                    operationBuilder.setAttr("description", options2.description);
                }
                if (options2.labels != null) {
                    String[] stringArray = new String[options2.labels.size()];
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        stringArray[i3] = (String)options2.labels.get(i3);
                    }
                    operationBuilder.setAttr("labels", stringArray);
                }
                if (options2.displayName == null) continue;
                operationBuilder.setAttr("display_name", options2.displayName);
            }
        }
        return new TensorSummary(operationBuilder.build());
    }

    public static Options description(String description) {
        return new Options().description(description);
    }

    public static Options labels(List<String> labels) {
        return new Options().labels(labels);
    }

    public static Options displayName(String displayName) {
        return new Options().displayName(displayName);
    }

    public final Output<String> summary() {
        return this.summary;
    }

    @Override
    public final Output<String> asOutput() {
        return this.summary;
    }

    private TensorSummary(Operation operation) {
        super(operation);
        this.summary = operation.output(0);
    }

    public static class Options {
        private String description;
        private List<String> labels;
        private String displayName;

        public Options description(String description) {
            this.description = description;
            return this;
        }

        public Options labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Options displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        private Options() {
        }
    }
}

