/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Unstack<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> output;

    public static <T> Unstack<T> create(Scope scope, Operand<T> value, Long num, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Unpack", scope.makeOpName("Unstack"));
        operationBuilder.addInput(value.asOutput());
        operationBuilder.setAttr("num", num);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.axis == null) continue;
                operationBuilder.setAttr("axis", options2.axis);
            }
        }
        return new Unstack<T>(operationBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public final List<Output<T>> output() {
        return this.output;
    }

    @Override
    public final Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private Unstack(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(0, n2));
    }

    public static class Options {
        private Long axis;

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

