/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JavaVersionUtils {
    JAVA_VERSION;

    public static final int UNKNOWN = -1;
    private int majorVersion;

    private JavaVersionUtils() {
        String string2 = System.getProperty("java.version");
        this.majorVersion = this.parseMajor(string2);
    }

    public final int getMajor() {
        return this.majorVersion;
    }

    public final boolean isKnown() {
        return this.majorVersion != -1;
    }

    public final int parseMajor(String version) {
        Pattern pattern;
        Matcher matcher;
        if (version != null && (matcher = (pattern = Pattern.compile("1\\.([0-9]*).*|([0-9][0-9]*).*")).matcher(version)).matches()) {
            Matcher matcher2 = matcher;
            return Integer.parseInt(matcher2.group(matcher2.group(1) != null ? 1 : 2));
        }
        return -1;
    }

    public final boolean useUnifiedLogging() {
        return this.isKnown() && this.getMajor() >= 9;
    }
}

