/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.convert.TransformAccessArrayField;
import ai.h2o.javassist.convert.TransformAfter;
import ai.h2o.javassist.convert.TransformBefore;
import ai.h2o.javassist.convert.TransformCall;
import ai.h2o.javassist.convert.TransformCallToStatic;
import ai.h2o.javassist.convert.TransformFieldAccess;
import ai.h2o.javassist.convert.TransformNew;
import ai.h2o.javassist.convert.TransformNewClass;
import ai.h2o.javassist.convert.TransformReadField;
import ai.h2o.javassist.convert.TransformWriteField;
import ai.h2o.javassist.convert.Transformer;

public class CodeConverter {
    protected Transformer transformers = null;

    public void replaceNew(CtClass newClass, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformNew(this.transformers, newClass.getName(), calledClass.getName(), calledMethod);
    }

    public void replaceNew(CtClass oldClass, CtClass newClass) {
        this.transformers = new TransformNewClass(this.transformers, oldClass.getName(), newClass.getName());
    }

    public void redirectFieldAccess(CtField field, CtClass newClass, String newFieldname) {
        this.transformers = new TransformFieldAccess(this.transformers, field, newClass.getName(), newFieldname);
    }

    public void replaceFieldRead(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformReadField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceFieldWrite(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformWriteField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceArrayAccess(CtClass calledClass, ArrayAccessReplacementMethodNames names) throws NotFoundException {
        this.transformers = new TransformAccessArrayField(this.transformers, calledClass.getName(), names);
    }

    public void redirectMethodCall(CtMethod origMethod, CtMethod substMethod) throws CannotCompileException {
        String string;
        String string2 = origMethod.getMethodInfo2().getDescriptor();
        if (!string2.equals(string = substMethod.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch: " + substMethod.getLongName());
        }
        int n2 = origMethod.getModifiers();
        int n3 = substMethod.getModifiers();
        if (Modifier.isStatic(n2) != Modifier.isStatic(n3) || Modifier.isPrivate(n2) && !Modifier.isPrivate(n3) || origMethod.getDeclaringClass().isInterface() != substMethod.getDeclaringClass().isInterface()) {
            throw new CannotCompileException("invoke-type mismatch " + substMethod.getLongName());
        }
        this.transformers = new TransformCall(this.transformers, origMethod, substMethod);
    }

    public void redirectMethodCall(String oldMethodName, CtMethod newMethod) throws CannotCompileException {
        this.transformers = new TransformCall(this.transformers, oldMethodName, newMethod);
    }

    public void redirectMethodCallToStatic(CtMethod origMethod, CtMethod staticMethod) {
        this.transformers = new TransformCallToStatic(this.transformers, origMethod, staticMethod);
    }

    public void insertBeforeMethod(CtMethod origMethod, CtMethod beforeMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, origMethod, beforeMethod);
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public void insertAfterMethod(CtMethod origMethod, CtMethod afterMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, origMethod, afterMethod);
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    protected void doit(CtClass clazz, MethodInfo minfo, ConstPool cp) throws CannotCompileException {
        int n2;
        Transformer transformer;
        CodeAttribute codeAttribute = minfo.getCodeAttribute();
        if (codeAttribute == null || this.transformers == null) {
            return;
        }
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            transformer.initialize(cp, clazz, minfo);
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            try {
                n2 = codeIterator.next();
                for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
                    n2 = transformer.transform(clazz, n2, codeIterator, cp);
                }
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        n2 = 0;
        int n3 = 0;
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            int n4 = transformer.extraLocals();
            if (n4 > n2) {
                n2 = n4;
            }
            if ((n4 = transformer.extraStack()) <= n3) continue;
            n3 = n4;
        }
        for (transformer = this.transformers; transformer != null; transformer = transformer.getNext()) {
            transformer.clean();
        }
        if (n2 > 0) {
            CodeAttribute codeAttribute2 = codeAttribute;
            codeAttribute2.setMaxLocals(codeAttribute2.getMaxLocals() + n2);
        }
        if (n3 > 0) {
            CodeAttribute codeAttribute3 = codeAttribute;
            codeAttribute3.setMaxStack(codeAttribute3.getMaxStack() + n3);
        }
        try {
            minfo.rebuildStackMapIf6(clazz.getClassPool(), clazz.getClassFile2());
            return;
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode.getMessage(), badBytecode);
        }
    }

    public static class DefaultArrayAccessReplacementMethodNames
    implements ArrayAccessReplacementMethodNames {
        @Override
        public String byteOrBooleanRead() {
            return "arrayReadByteOrBoolean";
        }

        @Override
        public String byteOrBooleanWrite() {
            return "arrayWriteByteOrBoolean";
        }

        @Override
        public String charRead() {
            return "arrayReadChar";
        }

        @Override
        public String charWrite() {
            return "arrayWriteChar";
        }

        @Override
        public String doubleRead() {
            return "arrayReadDouble";
        }

        @Override
        public String doubleWrite() {
            return "arrayWriteDouble";
        }

        @Override
        public String floatRead() {
            return "arrayReadFloat";
        }

        @Override
        public String floatWrite() {
            return "arrayWriteFloat";
        }

        @Override
        public String intRead() {
            return "arrayReadInt";
        }

        @Override
        public String intWrite() {
            return "arrayWriteInt";
        }

        @Override
        public String longRead() {
            return "arrayReadLong";
        }

        @Override
        public String longWrite() {
            return "arrayWriteLong";
        }

        @Override
        public String objectRead() {
            return "arrayReadObject";
        }

        @Override
        public String objectWrite() {
            return "arrayWriteObject";
        }

        @Override
        public String shortRead() {
            return "arrayReadShort";
        }

        @Override
        public String shortWrite() {
            return "arrayWriteShort";
        }
    }

    public static interface ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead();

        public String byteOrBooleanWrite();

        public String charRead();

        public String charWrite();

        public String doubleRead();

        public String doubleWrite();

        public String floatRead();

        public String floatWrite();

        public String intRead();

        public String intWrite();

        public String longRead();

        public String longWrite();

        public String objectRead();

        public String objectWrite();

        public String shortRead();

        public String shortWrite();
    }
}

