/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewWrappedMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;

public class CtNewMethod {
    public static CtMethod make(String src, CtClass declaring) throws CannotCompileException {
        return CtNewMethod.make(src, declaring, null, null);
    }

    public static CtMethod make(String src, CtClass declaring, String delegateObj, String delegateMethod) throws CannotCompileException {
        Javac javac = new Javac(declaring);
        try {
            CtMember ctMember;
            if (delegateMethod != null) {
                javac.recordProceed(delegateObj, delegateMethod);
            }
            if ((ctMember = javac.compile(src)) instanceof CtMethod) {
                return (CtMethod)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a method");
    }

    public static CtMethod make(CtClass returnType, String mname, CtClass[] parameters, CtClass[] exceptions, String body, CtClass declaring) throws CannotCompileException {
        return CtNewMethod.make(1, returnType, mname, parameters, exceptions, body, declaring);
    }

    public static CtMethod make(int modifiers, CtClass returnType, String mname, CtClass[] parameters, CtClass[] exceptions, String body, CtClass declaring) throws CannotCompileException {
        try {
            CtMethod ctMethod = new CtMethod(returnType, mname, parameters, declaring);
            ctMethod.setModifiers(modifiers);
            ctMethod.setExceptionTypes(exceptions);
            ctMethod.setBody(body);
            return ctMethod;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public static CtMethod copy(CtMethod src, CtClass declaring, ClassMap map) throws CannotCompileException {
        return new CtMethod(src, declaring, map);
    }

    public static CtMethod copy(CtMethod src, String name, CtClass declaring, ClassMap map) throws CannotCompileException {
        CtMethod ctMethod = new CtMethod(src, declaring, map);
        ctMethod.setName(name);
        return ctMethod;
    }

    public static CtMethod abstractMethod(CtClass returnType, String mname, CtClass[] parameters, CtClass[] exceptions, CtClass declaring) throws NotFoundException {
        CtMethod ctMethod = new CtMethod(returnType, mname, parameters, declaring);
        ctMethod.setExceptionTypes(exceptions);
        return ctMethod;
    }

    public static CtMethod getter(String methodName, CtField field) throws CannotCompileException {
        Object object;
        FieldInfo fieldInfo = field.getFieldInfo2();
        String string = fieldInfo.getDescriptor();
        String string2 = "()" + string;
        ConstPool constPool = fieldInfo.getConstPool();
        MethodInfo methodInfo = new MethodInfo(constPool, methodName, string2);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(constPool, 2, 1);
        try {
            object = fieldInfo.getName();
            if ((fieldInfo.getAccessFlags() & 8) == 0) {
                bytecode.addAload(0);
                bytecode.addGetfield(Bytecode.THIS, (String)object, string);
            } else {
                bytecode.addGetstatic(Bytecode.THIS, (String)object, string);
            }
            bytecode.addReturn(field.getType());
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        object = field.getDeclaringClass();
        return new CtMethod(methodInfo, (CtClass)object);
    }

    public static CtMethod setter(String methodName, CtField field) throws CannotCompileException {
        Object object;
        FieldInfo fieldInfo = field.getFieldInfo2();
        String string = fieldInfo.getDescriptor();
        String string2 = "(" + string + ")V";
        ConstPool constPool = fieldInfo.getConstPool();
        MethodInfo methodInfo = new MethodInfo(constPool, methodName, string2);
        methodInfo.setAccessFlags(1);
        Bytecode bytecode = new Bytecode(constPool, 3, 3);
        try {
            object = fieldInfo.getName();
            if ((fieldInfo.getAccessFlags() & 8) == 0) {
                bytecode.addAload(0);
                bytecode.addLoad(1, field.getType());
                bytecode.addPutfield(Bytecode.THIS, (String)object, string);
            } else {
                bytecode.addLoad(1, field.getType());
                bytecode.addPutstatic(Bytecode.THIS, (String)object, string);
            }
            bytecode.addReturn(null);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        object = field.getDeclaringClass();
        return new CtMethod(methodInfo, (CtClass)object);
    }

    public static CtMethod delegator(CtMethod delegate, CtClass declaring) throws CannotCompileException {
        try {
            return CtNewMethod.delegator0(delegate, declaring);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    private static CtMethod delegator0(CtMethod delegate, CtClass declaring) throws CannotCompileException, NotFoundException {
        int n2;
        MethodInfo methodInfo = delegate.getMethodInfo2();
        String string = methodInfo.getName();
        String string2 = methodInfo.getDescriptor();
        ConstPool constPool = declaring.getClassFile2().getConstPool();
        MethodInfo methodInfo2 = new MethodInfo(constPool, string, string2);
        methodInfo2.setAccessFlags(methodInfo.getAccessFlags());
        ExceptionsAttribute exceptionsAttribute = methodInfo.getExceptionsAttribute();
        if (exceptionsAttribute != null) {
            methodInfo2.setExceptionsAttribute((ExceptionsAttribute)exceptionsAttribute.copy(constPool, null));
        }
        Bytecode bytecode = new Bytecode(constPool, 0, 0);
        boolean bl = Modifier.isStatic(delegate.getModifiers());
        CtClass ctClass = delegate.getDeclaringClass();
        CtClass[] ctClassArray = delegate.getParameterTypes();
        if (bl) {
            n2 = bytecode.addLoadParameters(ctClassArray, 0);
            bytecode.addInvokestatic(ctClass, string, string2);
        } else {
            bytecode.addLoad(0, ctClass);
            n2 = bytecode.addLoadParameters(ctClassArray, 1);
            bytecode.addInvokespecial(ctClass, string, string2);
        }
        bytecode.addReturn(delegate.getReturnType());
        bytecode.setMaxLocals(++n2);
        bytecode.setMaxStack(n2 < 2 ? 2 : n2);
        methodInfo2.setCodeAttribute(bytecode.toCodeAttribute());
        return new CtMethod(methodInfo2, declaring);
    }

    public static CtMethod wrapped(CtClass returnType, String mname, CtClass[] parameterTypes, CtClass[] exceptionTypes, CtMethod body, CtMethod.ConstParameter constParam, CtClass declaring) throws CannotCompileException {
        return CtNewWrappedMethod.wrapped(returnType, mname, parameterTypes, exceptionTypes, body, constParam, declaring);
    }
}

