/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.ConstInfo;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

class ClassInfo
extends ConstInfo {
    static final int tag = 7;
    int name;

    public ClassInfo(int className, int index) {
        super(index);
        this.name = className;
    }

    public ClassInfo(DataInputStream in, int index) throws IOException {
        super(index);
        this.name = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassInfo && ((ClassInfo)obj).name == this.name;
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public String getClassName(ConstPool cp) {
        return cp.getUtf8Info(this.name);
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName, Map<ConstInfo, ConstInfo> cache) {
        String string;
        String string2 = cp.getUtf8Info(this.name);
        String string3 = null;
        if (string2.equals(oldName)) {
            string3 = newName;
        } else if (string2.charAt(0) == '[' && string2 != (string = Descriptor.rename(string2, oldName, newName))) {
            string3 = string;
        }
        if (string3 != null) {
            if (cache == null) {
                this.name = cp.addUtf8Info(string3);
                return;
            }
            cache.remove(this);
            this.name = cp.addUtf8Info(string3);
            ClassInfo classInfo = this;
            cache.put(classInfo, classInfo);
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<String, String> map, Map<ConstInfo, ConstInfo> cache) {
        String string = cp.getUtf8Info(this.name);
        String string2 = null;
        if (string.charAt(0) == '[') {
            String string3 = Descriptor.rename(string, map);
            if (string != string3) {
                string2 = string3;
            }
        } else {
            String string4 = map.get(string);
            if (string4 != null && !string4.equals(string)) {
                string2 = string4;
            }
        }
        if (string2 != null) {
            if (cache == null) {
                this.name = cp.addUtf8Info(string2);
                return;
            }
            cache.remove(this);
            this.name = cp.addUtf8Info(string2);
            ClassInfo classInfo = this;
            cache.put(classInfo, classInfo);
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<String, String> map) {
        String string;
        String string2 = src.getUtf8Info(this.name);
        if (map != null && (string = map.get(string2)) != null) {
            string2 = string;
        }
        return dest.addClassInfo(string2);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(7);
        out.writeShort(this.name);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Class #");
        out.println(this.name);
    }
}

