/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class LineNumberAttribute
extends AttributeInfo {
    public static final String tag = "LineNumberTable";

    LineNumberAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    private LineNumberAttribute(ConstPool cp, byte[] i2) {
        super(cp, tag, i2);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public int startPc(int i2) {
        return ByteArray.readU16bit(this.info, (i2 << 2) + 2);
    }

    public int lineNumber(int i2) {
        return ByteArray.readU16bit(this.info, (i2 << 2) + 4);
    }

    public int toLineNumber(int pc) {
        int n2;
        int n3 = this.tableLength();
        for (n2 = 0; n2 < n3; ++n2) {
            if (pc >= this.startPc(n2)) continue;
            if (n2 != 0) break;
            return this.lineNumber(0);
        }
        return this.lineNumber(n2 - 1);
    }

    public int toStartPc(int line) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (line != this.lineNumber(i2)) continue;
            return this.startPc(i2);
        }
        return -1;
    }

    public Pc toNearPc(int line) {
        int n2 = this.tableLength();
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.lineNumber(0) - line;
            n3 = this.startPc(0);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            int n5 = this.lineNumber(i2) - line;
            if ((n5 >= 0 || n5 <= n4) && (n5 < 0 || n5 >= n4 && n4 >= 0)) continue;
            n4 = n5;
            n3 = this.startPc(i2);
        }
        Pc pc = new Pc();
        new Pc().index = n3;
        pc.line = line + n4;
        return pc;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        byte[] byArray = this.info;
        int n2 = this.info.length;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        LineNumberAttribute lineNumberAttribute = new LineNumberAttribute(newCp, byArray2);
        return lineNumberAttribute;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (i2 << 2) + 2;
            int n4 = ByteArray.readU16bit(this.info, n3);
            if (n4 <= where && (!exclusive || n4 != where)) continue;
            ByteArray.write16bit(n4 + gapLength, this.info, n3);
        }
    }

    public static class Pc {
        public int index;
        public int line;
    }
}

