/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.LocalVariableAttribute;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.JvstCodeGen;
import ai.h2o.javassist.compiler.JvstTypeChecker;
import ai.h2o.javassist.compiler.Lex;
import ai.h2o.javassist.compiler.MemberResolver;
import ai.h2o.javassist.compiler.Parser;
import ai.h2o.javassist.compiler.ProceedHandler;
import ai.h2o.javassist.compiler.SymbolTable;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.FieldDecl;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.MethodDecl;
import ai.h2o.javassist.compiler.ast.Stmnt;
import ai.h2o.javassist.compiler.ast.Symbol;

public class Javac {
    JvstCodeGen gen;
    SymbolTable stable;
    private Bytecode bytecode;
    public static final String param0Name = "$0";
    public static final String resultVarName = "$_";
    public static final String proceedName = "$proceed";

    public Javac(CtClass thisClass) {
        this(new Bytecode(thisClass.getClassFile2().getConstPool(), 0, 0), thisClass);
    }

    public Javac(Bytecode b2, CtClass thisClass) {
        CtClass ctClass = thisClass;
        this.gen = new JvstCodeGen(b2, ctClass, ctClass.getClassPool());
        this.stable = new SymbolTable();
        this.bytecode = b2;
    }

    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public CtMember compile(String src) throws CompileError {
        Parser parser = new Parser(new Lex(src));
        ASTList aSTList = parser.parseMember1(this.stable);
        try {
            if (aSTList instanceof FieldDecl) {
                return this.compileField((FieldDecl)aSTList);
            }
            CtBehavior ctBehavior = this.compileMethod(parser, (MethodDecl)aSTList);
            CtClass ctClass = ctBehavior.getDeclaringClass();
            ctBehavior.getMethodInfo2().rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return ctBehavior;
        }
        catch (BadBytecode badBytecode) {
            throw new CompileError(badBytecode.getMessage());
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException.getMessage());
        }
    }

    private CtField compileField(FieldDecl fd) throws CompileError, CannotCompileException {
        Declarator declarator = fd.getDeclarator();
        CtFieldWithInit ctFieldWithInit = new CtFieldWithInit(this.gen.resolver.lookupClass(declarator), declarator.getVariable().get(), this.gen.getThisClass());
        ctFieldWithInit.setModifiers(MemberResolver.getModifiers(fd.getModifiers()));
        if (fd.getInit() != null) {
            ctFieldWithInit.setInit(fd.getInit());
        }
        return ctFieldWithInit;
    }

    private CtBehavior compileMethod(Parser p2, MethodDecl md) throws CompileError {
        int n2 = MemberResolver.getModifiers(md.getModifiers());
        CtClass[] ctClassArray = this.gen.makeParamList(md);
        CtClass[] ctClassArray2 = this.gen.makeThrowsList(md);
        this.recordParams(ctClassArray, Modifier.isStatic(n2));
        md = p2.parseMethod2(this.stable, md);
        try {
            if (md.isConstructor()) {
                CtConstructor ctConstructor = new CtConstructor(ctClassArray, this.gen.getThisClass());
                ctConstructor.setModifiers(n2);
                md.accept(this.gen);
                ctConstructor.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
                ctConstructor.setExceptionTypes(ctClassArray2);
                return ctConstructor;
            }
            Declarator declarator = md.getReturn();
            CtClass ctClass = this.gen.resolver.lookupClass(declarator);
            this.recordReturnType(ctClass, false);
            CtMethod ctMethod = new CtMethod(ctClass, declarator.getVariable().get(), ctClassArray, this.gen.getThisClass());
            ctMethod.setModifiers(n2);
            this.gen.setThisMethod(ctMethod);
            md.accept(this.gen);
            if (md.getBody() != null) {
                ctMethod.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
            } else {
                ctMethod.setModifiers(n2 | 0x400);
            }
            ctMethod.setExceptionTypes(ctClassArray2);
            return ctMethod;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    public Bytecode compileBody(CtBehavior method, String src) throws CompileError {
        try {
            boolean bl;
            CtClass ctClass;
            int n2 = method.getModifiers();
            this.recordParams(method.getParameterTypes(), Modifier.isStatic(n2));
            if (method instanceof CtMethod) {
                this.gen.setThisMethod((CtMethod)method);
                ctClass = ((CtMethod)method).getReturnType();
            } else {
                ctClass = CtClass.voidType;
            }
            this.recordReturnType(ctClass, false);
            boolean bl2 = bl = ctClass == CtClass.voidType;
            if (src == null) {
                Javac.makeDefaultBody(this.bytecode, ctClass);
            } else {
                Parser parser = new Parser(new Lex(src));
                SymbolTable symbolTable = new SymbolTable(this.stable);
                Stmnt stmnt = parser.parseStatement(symbolTable);
                if (parser.hasMore()) {
                    throw new CompileError("the method/constructor body must be surrounded by {}");
                }
                boolean bl3 = false;
                if (method instanceof CtConstructor) {
                    bl3 = !((CtConstructor)method).isClassInitializer();
                }
                this.gen.atMethodBody(stmnt, bl3, bl);
            }
            return this.bytecode;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    private static void makeDefaultBody(Bytecode b2, CtClass type) {
        int n2;
        int n3;
        if (type instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)type;
            n3 = ctPrimitiveType.getReturnOp();
            n2 = n3 == 175 ? 14 : (n3 == 174 ? 11 : (n3 == 173 ? 9 : (n3 == 177 ? 0 : 3)));
        } else {
            n3 = 176;
            n2 = 1;
        }
        if (n2 != 0) {
            b2.addOpcode(n2);
        }
        b2.addOpcode(n3);
    }

    public boolean recordLocalVariables(CodeAttribute ca, int pc) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n2 = localVariableAttribute.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = localVariableAttribute.startPc(i2);
            int n4 = localVariableAttribute.codeLength(i2);
            if (n3 > pc || pc >= n3 + n4) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i2), localVariableAttribute.variableName(i2), localVariableAttribute.index(i2), this.stable);
        }
        return true;
    }

    public boolean recordParamNames(CodeAttribute ca, int numOfLocalVars) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n2 = localVariableAttribute.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = localVariableAttribute.index(i2);
            if (n3 >= numOfLocalVars) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i2), localVariableAttribute.variableName(i2), n3, this.stable);
        }
        return true;
    }

    public int recordParams(CtClass[] params, boolean isStatic) throws CompileError {
        return this.gen.recordParams(params, isStatic, "$", "$args", "$$", this.stable);
    }

    public int recordParams(String target, CtClass[] params, boolean use0, int varNo, boolean isStatic) throws CompileError {
        return this.gen.recordParams(params, isStatic, "$", "$args", "$$", use0, varNo, target, this.stable);
    }

    public void setMaxLocals(int max) {
        this.gen.setMaxLocals(max);
    }

    public int recordReturnType(CtClass type, boolean useResultVar) throws CompileError {
        this.gen.recordType(type);
        return this.gen.recordReturnType(type, "$r", useResultVar ? resultVarName : null, this.stable);
    }

    public void recordType(CtClass t2) {
        this.gen.recordType(t2);
    }

    public int recordVariable(CtClass type, String name) throws CompileError {
        return this.gen.recordVariable(type, name, this.stable);
    }

    public void recordProceed(String target, String method) throws CompileError {
        Parser parser = new Parser(new Lex(target));
        final ASTree aSTree = parser.parseExpression(this.stable);
        final String string = method;
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args) throws CompileError {
                ASTree aSTree2 = new Member(string);
                if (aSTree != null) {
                    aSTree2 = Expr.make(46, aSTree, aSTree2);
                }
                aSTree2 = CallExpr.makeCall(aSTree2, args);
                gen.compileExpr(aSTree2);
                gen.addNullIfVoid();
            }

            @Override
            public void setReturnType(JvstTypeChecker check, ASTList args) throws CompileError {
                ASTree aSTree2 = new Member(string);
                if (aSTree != null) {
                    aSTree2 = Expr.make(46, aSTree, aSTree2);
                }
                aSTree2 = CallExpr.makeCall(aSTree2, args);
                ((ASTree)aSTree2).accept(check);
                check.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordStaticProceed(String targetClass, String method) throws CompileError {
        final String string = targetClass;
        final String string2 = method;
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args) throws CompileError {
                Expr expr = Expr.make(35, (ASTree)new Symbol(string), (ASTree)new Member(string2));
                expr = CallExpr.makeCall(expr, args);
                gen.compileExpr(expr);
                gen.addNullIfVoid();
            }

            @Override
            public void setReturnType(JvstTypeChecker check, ASTList args) throws CompileError {
                Expr expr = Expr.make(35, (ASTree)new Symbol(string), (ASTree)new Member(string2));
                expr = CallExpr.makeCall(expr, args);
                expr.accept(check);
                check.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordSpecialProceed(String target, final String classname, final String methodname, final String descriptor, final int methodIndex) throws CompileError {
        Parser parser = new Parser(new Lex(target));
        final ASTree aSTree = parser.parseExpression(this.stable);
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen gen, Bytecode b2, ASTList args) throws CompileError {
                gen.compileInvokeSpecial(aSTree, methodIndex, descriptor, args);
            }

            @Override
            public void setReturnType(JvstTypeChecker c2, ASTList args) throws CompileError {
                c2.compileInvokeSpecial(aSTree, classname, methodname, descriptor, args);
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordProceed(ProceedHandler h2) {
        this.gen.setProceedHandler(h2, proceedName);
    }

    public void compileStmnt(String src) throws CompileError {
        Parser parser = new Parser(new Lex(src));
        SymbolTable symbolTable = new SymbolTable(this.stable);
        while (parser.hasMore()) {
            Stmnt stmnt = parser.parseStatement(symbolTable);
            if (stmnt == null) continue;
            stmnt.accept(this.gen);
        }
    }

    public void compileExpr(String src) throws CompileError {
        ASTree aSTree = Javac.parseExpr(src, this.stable);
        this.compileExpr(aSTree);
    }

    public static ASTree parseExpr(String src, SymbolTable st) throws CompileError {
        Parser parser = new Parser(new Lex(src));
        return parser.parseExpression(st);
    }

    public void compileExpr(ASTree e2) throws CompileError {
        if (e2 != null) {
            this.gen.compileExpr(e2);
        }
    }

    public static class CtFieldWithInit
    extends CtField {
        private ASTree init = null;

        CtFieldWithInit(CtClass type, String name, CtClass declaring) throws CannotCompileException {
            super(type, name, declaring);
        }

        protected void setInit(ASTree i2) {
            this.init = i2;
        }

        @Override
        protected ASTree getInitAST() {
            return this.init;
        }
    }
}

