/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.compiler.CodeGen;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.MemberResolver;
import ai.h2o.javassist.compiler.NoFieldException;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.ArrayInit;
import ai.h2o.javassist.compiler.ast.AssignExpr;
import ai.h2o.javassist.compiler.ast.BinExpr;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.CastExpr;
import ai.h2o.javassist.compiler.ast.CondExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.DoubleConst;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.InstanceOfExpr;
import ai.h2o.javassist.compiler.ast.IntConst;
import ai.h2o.javassist.compiler.ast.Keyword;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.NewExpr;
import ai.h2o.javassist.compiler.ast.StringL;
import ai.h2o.javassist.compiler.ast.Symbol;
import ai.h2o.javassist.compiler.ast.Variable;
import ai.h2o.javassist.compiler.ast.Visitor;
import java.io.Serializable;

public class TypeChecker
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String jvmJavaLangString = "java/lang/String";
    static final String jvmJavaLangClass = "java/lang/Class";
    protected int exprType;
    protected int arrayDim;
    protected String className;
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;

    public TypeChecker(CtClass cc, ClassPool cp) {
        this.resolver = new MemberResolver(cp);
        this.thisClass = cc;
        this.thisMethod = null;
    }

    protected static String argTypesToString(int[] types, int[] dims, String[] cnames) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n2 = types.length;
        if (n2 > 0) {
            int n3 = 0;
            while (true) {
                TypeChecker.typeToString(stringBuffer, types[n3], dims[n3], cnames[n3]);
                if (++n3 >= n2) break;
                stringBuffer.append(',');
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static StringBuffer typeToString(StringBuffer sbuf, int type, int dim, String cname) {
        String string;
        if (type == 307) {
            string = MemberResolver.jvmToJavaName(cname);
        } else if (type == 412) {
            string = "Object";
        } else {
            try {
                string = MemberResolver.getTypeName(type);
            }
            catch (CompileError compileError) {
                string = "?";
            }
        }
        sbuf.append(string);
        while (dim-- > 0) {
            sbuf.append("[]");
        }
        return sbuf;
    }

    public void setThisMethod(MethodInfo m2) {
        this.thisMethod = m2;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    protected String resolveClassName(ASTList name) throws CompileError {
        return this.resolver.resolveClassName(name);
    }

    protected String resolveClassName(String jvmName) throws CompileError {
        return this.resolver.resolveJvmClassName(jvmName);
    }

    @Override
    public void atNewExpr(NewExpr expr) throws CompileError {
        if (expr.isArray()) {
            this.atNewArrayExpr(expr);
            return;
        }
        CtClass ctClass = this.resolver.lookupClassByName(expr.getClassName());
        String string = ctClass.getName();
        ASTList aSTList = expr.getArguments();
        this.atMethodCallCore(ctClass, "<init>", aSTList);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = MemberResolver.javaToJvmName(string);
    }

    public void atNewArrayExpr(NewExpr expr) throws CompileError {
        int n2 = expr.getArrayType();
        ASTList aSTList = expr.getArraySize();
        ASTList aSTList2 = expr.getClassName();
        ArrayInit arrayInit = expr.getInitializer();
        if (arrayInit != null) {
            ((ASTree)arrayInit).accept(this);
        }
        if (aSTList.length() > 1) {
            this.atMultiNewArray(n2, aSTList2, aSTList);
            return;
        }
        ASTree aSTree = aSTList.head();
        if (aSTree != null) {
            aSTree.accept(this);
        }
        this.exprType = n2;
        this.arrayDim = 1;
        if (n2 == 307) {
            this.className = this.resolveClassName(aSTList2);
            return;
        }
        this.className = null;
    }

    @Override
    public void atArrayInit(ArrayInit init) throws CompileError {
        for (ASTList aSTList = init; aSTList != null; aSTList = aSTList.tail()) {
            ASTree aSTree = aSTList.head();
            if (aSTree == null) continue;
            aSTree.accept(this);
        }
    }

    protected void atMultiNewArray(int type, ASTList classname, ASTList size) throws CompileError {
        ASTree aSTree;
        int n2 = size.length();
        while (size != null && (aSTree = size.head()) != null) {
            aSTree.accept(this);
            size = size.tail();
        }
        this.exprType = type;
        this.arrayDim = n2;
        if (type == 307) {
            this.className = this.resolveClassName(classname);
            return;
        }
        this.className = null;
    }

    @Override
    public void atAssignExpr(AssignExpr expr) throws CompileError {
        Expr expr2;
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        ASTree aSTree2 = expr.oprand2();
        if (aSTree instanceof Variable) {
            this.atVariableAssign(expr, n2, (Variable)aSTree, ((Variable)aSTree).getDeclarator(), aSTree2);
            return;
        }
        if (aSTree instanceof Expr && (expr2 = (Expr)aSTree).getOperator() == 65) {
            this.atArrayAssign(expr, n2, (Expr)aSTree, aSTree2);
            return;
        }
        this.atFieldAssign(expr, n2, aSTree, aSTree2);
    }

    private void atVariableAssign(Expr expr, int op, Variable var, Declarator d2, ASTree right) throws CompileError {
        int n2 = d2.getType();
        int n3 = d2.getArrayDim();
        String string = d2.getClassName();
        if (op != 61) {
            this.atVariable(var);
        }
        right.accept(this);
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    private void atArrayAssign(Expr expr, int op, Expr array, ASTree right) throws CompileError {
        this.atArrayRead(array.oprand1(), array.oprand2());
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        right.accept(this);
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right) throws CompileError {
        CtField ctField = this.fieldAccess(left);
        this.atFieldRead(ctField);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        right.accept(this);
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    @Override
    public void atCondExpr(CondExpr expr) throws CompileError {
        this.booleanExpr(expr.condExpr());
        expr.thenExpr().accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        expr.elseExpr().accept(this);
        if (n3 == 0 && n3 == this.arrayDim) {
            if (CodeGen.rightIsStrong(n2, this.exprType)) {
                expr.setThen(new CastExpr(this.exprType, 0, expr.thenExpr()));
                return;
            }
            if (CodeGen.rightIsStrong(this.exprType, n2)) {
                expr.setElse(new CastExpr(n2, 0, expr.elseExpr()));
                this.exprType = n2;
            }
        }
    }

    @Override
    public void atBinExpr(BinExpr expr) throws CompileError {
        int n2 = expr.getOperator();
        int n3 = CodeGen.lookupBinOp(n2);
        if (n3 >= 0) {
            if (n2 == 43) {
                Expr expr2 = this.atPlusExpr(expr);
                if (expr2 != null) {
                    expr2 = CallExpr.makeCall(Expr.make(46, (ASTree)expr2, (ASTree)new Member("toString")), null);
                    expr.setOprand1(expr2);
                    expr.setOprand2(null);
                    this.className = jvmJavaLangString;
                }
                return;
            }
            ASTree aSTree = expr.oprand1();
            ASTree aSTree2 = expr.oprand2();
            aSTree.accept(this);
            int n4 = this.exprType;
            aSTree2.accept(this);
            if (!this.isConstant(expr, n2, aSTree, aSTree2)) {
                this.computeBinExprType(expr, n2, n4);
            }
            return;
        }
        this.booleanExpr(expr);
    }

    private Expr atPlusExpr(BinExpr expr) throws CompileError {
        ASTree aSTree = expr.oprand1();
        ASTree aSTree2 = expr.oprand2();
        if (aSTree2 == null) {
            aSTree.accept(this);
            return null;
        }
        if (TypeChecker.isPlusExpr(aSTree)) {
            Expr expr2 = this.atPlusExpr((BinExpr)aSTree);
            if (expr2 != null) {
                aSTree2.accept(this);
                this.exprType = 307;
                this.arrayDim = 0;
                this.className = "java/lang/StringBuffer";
                return TypeChecker.makeAppendCall(expr2, aSTree2);
            }
        } else {
            aSTree.accept(this);
        }
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        aSTree2.accept(this);
        if (this.isConstant(expr, 43, aSTree, aSTree2)) {
            return null;
        }
        if (n2 == 307 && n3 == 0 && jvmJavaLangString.equals(string) || this.exprType == 307 && this.arrayDim == 0 && jvmJavaLangString.equals(this.className)) {
            ASTList aSTList = ASTList.make(new Symbol("java"), new Symbol("lang"), new Symbol("StringBuffer"));
            NewExpr newExpr = new NewExpr(aSTList, null);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/StringBuffer";
            return TypeChecker.makeAppendCall(TypeChecker.makeAppendCall(newExpr, aSTree), aSTree2);
        }
        this.computeBinExprType(expr, 43, n2);
        return null;
    }

    private boolean isConstant(BinExpr expr, int op, ASTree left, ASTree right) throws CompileError {
        left = TypeChecker.stripPlusExpr(left);
        right = TypeChecker.stripPlusExpr(right);
        ASTree aSTree = null;
        if (left instanceof StringL && right instanceof StringL && op == 43) {
            aSTree = new StringL(((StringL)left).get() + ((StringL)right).get());
        } else if (left instanceof IntConst) {
            aSTree = ((IntConst)left).compute(op, right);
        } else if (left instanceof DoubleConst) {
            aSTree = ((DoubleConst)left).compute(op, right);
        }
        if (aSTree == null) {
            return false;
        }
        expr.setOperator(43);
        expr.setOprand1(aSTree);
        expr.setOprand2(null);
        aSTree.accept(this);
        return true;
    }

    static ASTree stripPlusExpr(ASTree expr) {
        ASTree aSTree;
        if (expr instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)expr;
            if (binExpr.getOperator() == 43 && binExpr.oprand2() == null) {
                return binExpr.getLeft();
            }
        } else if (expr instanceof Expr) {
            Expr expr2 = (Expr)expr;
            int n2 = expr2.getOperator();
            if (n2 == 35) {
                ASTree aSTree2 = TypeChecker.getConstantFieldValue((Member)expr2.oprand2());
                if (aSTree2 != null) {
                    return aSTree2;
                }
            } else if (n2 == 43 && expr2.getRight() == null) {
                return expr2.getLeft();
            }
        } else if (expr instanceof Member && (aSTree = TypeChecker.getConstantFieldValue((Member)expr)) != null) {
            return aSTree;
        }
        return expr;
    }

    private static ASTree getConstantFieldValue(Member mem) {
        return TypeChecker.getConstantFieldValue(mem.getField());
    }

    public static ASTree getConstantFieldValue(CtField f2) {
        if (f2 == null) {
            return null;
        }
        Object object = f2.getConstantValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringL((String)object);
        }
        if (object instanceof Double || object instanceof Float) {
            int n2 = object instanceof Double ? 405 : 404;
            return new DoubleConst(((Number)object).doubleValue(), n2);
        }
        if (object instanceof Number) {
            int n3 = object instanceof Long ? 403 : 402;
            return new IntConst(((Number)object).longValue(), n3);
        }
        if (object instanceof Boolean) {
            return new Keyword((Boolean)object != false ? 410 : 411);
        }
        return null;
    }

    private static boolean isPlusExpr(ASTree expr) {
        if (expr instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)expr;
            int n2 = binExpr.getOperator();
            return n2 == 43;
        }
        return false;
    }

    private static Expr makeAppendCall(ASTree target, ASTree arg) {
        return CallExpr.makeCall(Expr.make(46, target, (ASTree)new Member("append")), new ASTList(arg));
    }

    private void computeBinExprType(BinExpr expr, int token, int type1) throws CompileError {
        int n2 = this.exprType;
        if (token == 364 || token == 366 || token == 370) {
            this.exprType = type1;
        } else {
            this.insertCast(expr, type1, n2);
        }
        if (CodeGen.isP_INT(this.exprType) && this.exprType != 301) {
            this.exprType = 324;
        }
    }

    private void booleanExpr(ASTree expr) throws CompileError {
        int n2 = CodeGen.getCompOperator(expr);
        if (n2 == 358) {
            BinExpr binExpr = (BinExpr)expr;
            binExpr.oprand1().accept(this);
            int n3 = this.exprType;
            int n4 = this.arrayDim;
            binExpr.oprand2().accept(this);
            if (n4 == 0 && this.arrayDim == 0) {
                this.insertCast(binExpr, n3, this.exprType);
            }
        } else if (n2 == 33) {
            ((Expr)expr).oprand1().accept(this);
        } else if (n2 == 369 || n2 == 368) {
            BinExpr binExpr = (BinExpr)expr;
            binExpr.oprand1().accept(this);
            binExpr.oprand2().accept(this);
        } else {
            expr.accept(this);
        }
        this.exprType = 301;
        this.arrayDim = 0;
    }

    private void insertCast(BinExpr expr, int type1, int type2) throws CompileError {
        if (CodeGen.rightIsStrong(type1, type2)) {
            expr.setLeft(new CastExpr(type2, 0, expr.oprand1()));
            return;
        }
        this.exprType = type1;
    }

    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        String string = this.resolveClassName(expr.getClassName());
        expr.getOprand().accept(this);
        this.exprType = expr.getType();
        this.arrayDim = expr.getArrayDim();
        this.className = string;
    }

    @Override
    public void atInstanceOfExpr(InstanceOfExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void atExpr(Expr expr) throws CompileError {
        int n2 = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        if (n2 == 46) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("length")) {
                try {
                    this.atArrayLength(expr);
                    return;
                }
                catch (NoFieldException noFieldException) {}
            } else if (string.equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (n2 == 35) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (n2 == 65) {
            this.atArrayRead(aSTree, expr.oprand2());
            return;
        }
        if (n2 == 362 || n2 == 363) {
            this.atPlusPlus(n2, aSTree, expr);
            return;
        }
        if (n2 == 33) {
            this.booleanExpr(expr);
            return;
        }
        if (n2 == 67) {
            TypeChecker.fatal();
            return;
        }
        aSTree.accept(this);
        if (this.isConstant(expr, n2, aSTree)) return;
        if (n2 != 45) {
            if (n2 != 126) return;
        }
        if (!CodeGen.isP_INT(this.exprType)) return;
        this.exprType = 324;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConstant(Expr expr, int op, ASTree oprand) {
        if ((oprand = TypeChecker.stripPlusExpr(oprand)) instanceof IntConst) {
            IntConst intConst = (IntConst)oprand;
            long l2 = intConst.get();
            if (op == 45) {
                l2 = -l2;
            } else {
                if (op != 126) return false;
                l2 ^= 0xFFFFFFFFFFFFFFFFL;
            }
            intConst.set(l2);
        } else {
            if (!(oprand instanceof DoubleConst)) return false;
            DoubleConst doubleConst = (DoubleConst)oprand;
            if (op != 45) return false;
            DoubleConst doubleConst2 = doubleConst;
            doubleConst2.set(-doubleConst2.get());
        }
        expr.setOperator(43);
        return true;
    }

    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        Object object;
        String string = null;
        CtClass ctClass = null;
        ASTree aSTree = expr.oprand1();
        ASTList aSTList = (ASTList)expr.oprand2();
        if (aSTree instanceof Member) {
            string = ((Member)aSTree).get();
            ctClass = this.thisClass;
        } else if (aSTree instanceof Keyword) {
            string = "<init>";
            ctClass = ((Keyword)aSTree).get() == 336 ? MemberResolver.getSuperclass(this.thisClass) : this.thisClass;
        } else if (aSTree instanceof Expr) {
            object = (Expr)aSTree;
            string = ((Symbol)((Expr)object).oprand2()).get();
            int n2 = ((Expr)object).getOperator();
            if (n2 == 35) {
                ctClass = this.resolver.lookupClass(((Symbol)((Expr)object).oprand1()).get(), false);
            } else if (n2 == 46) {
                ASTree aSTree2 = ((Expr)object).oprand1();
                String string2 = TypeChecker.isDotSuper(aSTree2);
                if (string2 != null) {
                    ctClass = MemberResolver.getSuperInterface(this.thisClass, string2);
                } else {
                    try {
                        aSTree2.accept(this);
                    }
                    catch (NoFieldException noFieldException) {
                        NoFieldException noFieldException2 = noFieldException;
                        if (noFieldException.getExpr() != aSTree2) {
                            throw noFieldException2;
                        }
                        this.exprType = 307;
                        this.arrayDim = 0;
                        this.className = noFieldException2.getField();
                        ((Expr)object).setOperator(35);
                        ((Expr)object).setOprand1(new Symbol(MemberResolver.jvmToJavaName(this.className)));
                    }
                    if (this.arrayDim > 0) {
                        ctClass = this.resolver.lookupClass(javaLangObject, true);
                    } else if (this.exprType == 307) {
                        ctClass = this.resolver.lookupClassByJvmName(this.className);
                    } else {
                        TypeChecker.badMethod();
                    }
                }
            } else {
                TypeChecker.badMethod();
            }
        } else {
            TypeChecker.fatal();
        }
        object = this.atMethodCallCore(ctClass, string, aSTList);
        expr.setMethod((MemberResolver.Method)object);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    static String isDotSuper(ASTree target) {
        ASTree aSTree;
        Expr expr;
        if (target instanceof Expr && (expr = (Expr)target).getOperator() == 46 && (aSTree = expr.oprand2()) instanceof Keyword && ((Keyword)aSTree).get() == 336) {
            return ((Symbol)expr.oprand1()).get();
        }
        return null;
    }

    public MemberResolver.Method atMethodCallCore(CtClass targetClass, String mname, ASTList args) throws CompileError {
        int n2 = this.getMethodArgsLength(args);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        this.atMethodArgs(args, nArray, nArray2, stringArray);
        MemberResolver.Method method = this.resolver.lookupMethod(targetClass, this.thisClass, this.thisMethod, mname, nArray, nArray2, stringArray);
        if (method == null) {
            String string = targetClass.getName();
            String string2 = TypeChecker.argTypesToString(nArray, nArray2, stringArray);
            String string3 = mname.equals("<init>") ? "cannot find constructor " + string + string2 : mname + string2 + " not found in " + string;
            throw new CompileError(string3);
        }
        String string = method.info.getDescriptor();
        this.setReturnType(string);
        return method;
    }

    public int getMethodArgsLength(ASTList args) {
        return ASTList.length(args);
    }

    public void atMethodArgs(ASTList args, int[] types, int[] dims, String[] cnames) throws CompileError {
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            aSTree.accept(this);
            types[n2] = this.exprType;
            dims[n2] = this.arrayDim;
            cnames[n2] = this.className;
            ++n2;
            args = args.tail();
        }
    }

    void setReturnType(String desc) throws CompileError {
        int n2 = desc.indexOf(41);
        if (n2 < 0) {
            TypeChecker.badMethod();
        }
        char c2 = desc.charAt(++n2);
        int n3 = 0;
        while (c2 == '[') {
            ++n3;
            c2 = desc.charAt(++n2);
        }
        this.arrayDim = n3;
        if (c2 == 'L') {
            int n4 = desc.indexOf(59, n2 + 1);
            if (n4 < 0) {
                TypeChecker.badMethod();
            }
            this.exprType = 307;
            this.className = desc.substring(n2 + 1, n4);
            return;
        }
        this.exprType = MemberResolver.descToType(c2);
        this.className = null;
    }

    private void atFieldRead(ASTree expr) throws CompileError {
        TypeChecker typeChecker = this;
        typeChecker.atFieldRead(typeChecker.fieldAccess(expr));
    }

    private void atFieldRead(CtField f2) throws CompileError {
        FieldInfo fieldInfo = f2.getFieldInfo2();
        String string = fieldInfo.getDescriptor();
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(0);
        while (c2 == '[') {
            ++n3;
            c2 = string.charAt(++n2);
        }
        this.arrayDim = n3;
        this.exprType = MemberResolver.descToType(c2);
        if (c2 == 'L') {
            this.className = string.substring(n2 + 1, string.indexOf(59, n2 + 1));
            return;
        }
        this.className = null;
    }

    protected CtField fieldAccess(ASTree expr) throws CompileError {
        if (expr instanceof Member) {
            Member member = (Member)expr;
            String string = member.get();
            try {
                CtField ctField = this.thisClass.getField(string);
                if (Modifier.isStatic(ctField.getModifiers())) {
                    member.setField(ctField);
                }
                return ctField;
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(string, expr);
            }
        }
        if (expr instanceof Expr) {
            Expr expr2 = (Expr)expr;
            int n2 = expr2.getOperator();
            if (n2 == 35) {
                Member member = (Member)expr2.oprand2();
                CtField ctField = this.resolver.lookupField(((Symbol)expr2.oprand1()).get(), member);
                member.setField(ctField);
                return ctField;
            }
            if (n2 == 46) {
                Serializable serializable;
                try {
                    expr2.oprand1().accept(this);
                }
                catch (NoFieldException noFieldException) {
                    NoFieldException noFieldException2 = noFieldException;
                    if (noFieldException.getExpr() != expr2.oprand1()) {
                        throw noFieldException2;
                    }
                    return this.fieldAccess2(expr2, noFieldException2.getField());
                }
                CompileError compileError = null;
                try {
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        return this.resolver.lookupFieldByJvmName(this.className, (Symbol)expr2.oprand2());
                    }
                }
                catch (CompileError compileError2) {
                    serializable = compileError2;
                    compileError = compileError2;
                }
                serializable = expr2.oprand1();
                if (serializable instanceof Symbol) {
                    return this.fieldAccess2(expr2, ((Symbol)serializable).get());
                }
                if (compileError != null) {
                    throw compileError;
                }
            }
        }
        throw new CompileError("bad filed access");
    }

    private CtField fieldAccess2(Expr e2, String jvmClassName) throws CompileError {
        Member member = (Member)e2.oprand2();
        CtField ctField = this.resolver.lookupFieldByJvmName2(jvmClassName, member, e2);
        e2.setOperator(35);
        e2.setOprand1(new Symbol(MemberResolver.jvmToJavaName(jvmClassName)));
        member.setField(ctField);
        return ctField;
    }

    public void atClassObject(Expr expr) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangClass;
    }

    public void atArrayLength(Expr expr) throws CompileError {
        expr.oprand1().accept(this);
        if (this.arrayDim == 0) {
            throw new NoFieldException("length", expr);
        }
        this.exprType = 324;
        this.arrayDim = 0;
    }

    public void atArrayRead(ASTree array, ASTree index) throws CompileError {
        array.accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        index.accept(this);
        this.exprType = n2;
        this.arrayDim = n3 - 1;
        this.className = string;
    }

    private void atPlusPlus(int token, ASTree oprand, Expr expr) throws CompileError {
        Expr expr2;
        boolean bl = oprand == null;
        if (bl) {
            oprand = expr.oprand2();
        }
        if (oprand instanceof Variable) {
            Declarator declarator = ((Variable)oprand).getDeclarator();
            this.exprType = declarator.getType();
            this.arrayDim = declarator.getArrayDim();
            return;
        }
        if (oprand instanceof Expr && (expr2 = (Expr)oprand).getOperator() == 65) {
            this.atArrayRead(expr2.oprand1(), expr2.oprand2());
            int n2 = this.exprType;
            if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
                this.exprType = 324;
            }
            return;
        }
        this.atFieldPlusPlus(oprand);
    }

    protected void atFieldPlusPlus(ASTree oprand) throws CompileError {
        CtField ctField = this.fieldAccess(oprand);
        this.atFieldRead(ctField);
        int n2 = this.exprType;
        if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
            this.exprType = 324;
        }
    }

    @Override
    public void atMember(Member mem) throws CompileError {
        this.atFieldRead(mem);
    }

    @Override
    public void atVariable(Variable v2) throws CompileError {
        Declarator declarator = v2.getDeclarator();
        this.exprType = declarator.getType();
        this.arrayDim = declarator.getArrayDim();
        this.className = declarator.getClassName();
    }

    @Override
    public void atKeyword(Keyword k2) throws CompileError {
        this.arrayDim = 0;
        int n2 = k2.get();
        switch (n2) {
            case 410: 
            case 411: {
                this.exprType = 301;
                return;
            }
            case 412: {
                this.exprType = 412;
                return;
            }
            case 336: 
            case 339: {
                this.exprType = 307;
                if (n2 == 339) {
                    this.className = this.getThisName();
                    return;
                }
                this.className = this.getSuperName();
                return;
            }
        }
        TypeChecker.fatal();
    }

    @Override
    public void atStringL(StringL s2) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    @Override
    public void atIntConst(IntConst i2) throws CompileError {
        this.arrayDim = 0;
        int n2 = i2.getType();
        if (n2 == 402 || n2 == 401) {
            this.exprType = n2 == 402 ? 324 : 306;
            return;
        }
        this.exprType = 326;
    }

    @Override
    public void atDoubleConst(DoubleConst d2) throws CompileError {
        this.arrayDim = 0;
        if (d2.getType() == 405) {
            this.exprType = 312;
            return;
        }
        this.exprType = 317;
    }
}

