/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler.ast;

import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.ArrayInit;
import ai.h2o.javassist.compiler.ast.Visitor;

public class NewExpr
extends ASTList
implements TokenId {
    private static final long serialVersionUID = 1L;
    protected boolean newArray;
    protected int arrayType;

    public NewExpr(ASTList className, ASTList args) {
        super(className, new ASTList(args));
        this.newArray = false;
        this.arrayType = 307;
    }

    public NewExpr(int type, ASTList arraySize, ArrayInit init) {
        super(null, new ASTList(arraySize));
        this.newArray = true;
        this.arrayType = type;
        if (init != null) {
            NewExpr.append(this, init);
        }
    }

    public static NewExpr makeObjectArray(ASTList className, ASTList arraySize, ArrayInit init) {
        NewExpr newExpr = new NewExpr(className, arraySize);
        new NewExpr(className, arraySize).newArray = true;
        if (init != null) {
            NewExpr.append(newExpr, init);
        }
        return newExpr;
    }

    public boolean isArray() {
        return this.newArray;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public ASTList getClassName() {
        return (ASTList)this.getLeft();
    }

    public ASTList getArguments() {
        return (ASTList)this.getRight().getLeft();
    }

    public ASTList getArraySize() {
        return this.getArguments();
    }

    public ArrayInit getInitializer() {
        ASTree aSTree = this.getRight().getRight();
        if (aSTree == null) {
            return null;
        }
        return (ArrayInit)aSTree.getLeft();
    }

    @Override
    public void accept(Visitor v2) throws CompileError {
        v2.atNewExpr(this);
    }

    @Override
    protected String getTag() {
        if (this.newArray) {
            return "new[]";
        }
        return "new";
    }
}

