/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.util.proxy;

import ai.h2o.javassist.util.proxy.MethodHandler;
import ai.h2o.javassist.util.proxy.Proxy;
import ai.h2o.javassist.util.proxy.ProxyFactory;
import ai.h2o.javassist.util.proxy.ProxyObject;
import ai.h2o.javassist.util.proxy.SecurityActions;
import ai.h2o.javassist.util.proxy.SerializedProxy;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class RuntimeSupport {
    public static MethodHandler default_interceptor = new DefaultMethodHandler();

    public static void find2Methods(Class<?> clazz, String superMethod, String thisMethod, int index, String desc, Method[] methods) {
        methods[index + 1] = thisMethod == null ? null : RuntimeSupport.findMethod(clazz, thisMethod, desc);
        methods[index] = RuntimeSupport.findSuperClassMethod(clazz, superMethod, desc);
    }

    @Deprecated
    public static void find2Methods(Object self, String superMethod, String thisMethod, int index, String desc, Method[] methods) {
        methods[index + 1] = thisMethod == null ? null : RuntimeSupport.findMethod(self, thisMethod, desc);
        methods[index] = RuntimeSupport.findSuperMethod(self, superMethod, desc);
    }

    @Deprecated
    public static Method findMethod(Object self, String name, String desc) {
        Method method = RuntimeSupport.findMethod2(self.getClass(), name, desc);
        if (method == null) {
            RuntimeSupport.error(self.getClass(), name, desc);
        }
        return method;
    }

    public static Method findMethod(Class<?> clazz, String name, String desc) {
        Method method = RuntimeSupport.findMethod2(clazz, name, desc);
        if (method == null) {
            RuntimeSupport.error(clazz, name, desc);
        }
        return method;
    }

    public static Method findSuperMethod(Object self, String name, String desc) {
        Class<?> clazz = self.getClass();
        return RuntimeSupport.findSuperClassMethod(clazz, name, desc);
    }

    public static Method findSuperClassMethod(Class<?> clazz, String name, String desc) {
        Method method = RuntimeSupport.findSuperMethod2(clazz.getSuperclass(), name, desc);
        if (method == null) {
            method = RuntimeSupport.searchInterfaces(clazz, name, desc);
        }
        if (method == null) {
            RuntimeSupport.error(clazz, name, desc);
        }
        return method;
    }

    private static void error(Class<?> clazz, String name, String desc) {
        throw new RuntimeException("not found " + name + ":" + desc + " in " + clazz.getName());
    }

    private static Method findSuperMethod2(Class<?> clazz, String name, String desc) {
        Method method = RuntimeSupport.findMethod2(clazz, name, desc);
        if (method != null) {
            return method;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (method = RuntimeSupport.findSuperMethod2(clazz2, name, desc)) != null) {
            return method;
        }
        return RuntimeSupport.searchInterfaces(clazz, name, desc);
    }

    private static Method searchInterfaces(Class<?> clazz, String name, String desc) {
        Method method = null;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            method = RuntimeSupport.findSuperMethod2(classArray[i2], name, desc);
            if (method == null) continue;
            return method;
        }
        return method;
    }

    private static Method findMethod2(Class<?> clazz, String name, String desc) {
        Method[] methodArray = SecurityActions.getDeclaredMethods(clazz);
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!methodArray[i2].getName().equals(name) || !RuntimeSupport.makeDescriptor(methodArray[i2]).equals(desc)) continue;
            return methodArray[i2];
        }
        return null;
    }

    public static String makeDescriptor(Method m2) {
        Class<?>[] classArray = m2.getParameterTypes();
        return RuntimeSupport.makeDescriptor(classArray, m2.getReturnType());
    }

    public static String makeDescriptor(Class<?>[] params, Class<?> retType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < params.length; ++i2) {
            RuntimeSupport.makeDesc(stringBuffer, params[i2]);
        }
        stringBuffer.append(')');
        if (retType != null) {
            RuntimeSupport.makeDesc(stringBuffer, retType);
        }
        return stringBuffer.toString();
    }

    public static String makeDescriptor(String params, Class<?> retType) {
        StringBuffer stringBuffer = new StringBuffer(params);
        RuntimeSupport.makeDesc(stringBuffer, retType);
        return stringBuffer.toString();
    }

    private static void makeDesc(StringBuffer sbuf, Class<?> type) {
        if (type.isArray()) {
            sbuf.append('[');
            RuntimeSupport.makeDesc(sbuf, type.getComponentType());
            return;
        }
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                sbuf.append('V');
                return;
            }
            if (type == Integer.TYPE) {
                sbuf.append('I');
                return;
            }
            if (type == Byte.TYPE) {
                sbuf.append('B');
                return;
            }
            if (type == Long.TYPE) {
                sbuf.append('J');
                return;
            }
            if (type == Double.TYPE) {
                sbuf.append('D');
                return;
            }
            if (type == Float.TYPE) {
                sbuf.append('F');
                return;
            }
            if (type == Character.TYPE) {
                sbuf.append('C');
                return;
            }
            if (type == Short.TYPE) {
                sbuf.append('S');
                return;
            }
            if (type == Boolean.TYPE) {
                sbuf.append('Z');
                return;
            }
            throw new RuntimeException("bad type: " + type.getName());
        }
        sbuf.append('L').append(type.getName().replace('.', '/')).append(';');
    }

    public static SerializedProxy makeSerializedProxy(Object proxy) throws InvalidClassException {
        Class<?> clazz = proxy.getClass();
        MethodHandler methodHandler = null;
        if (proxy instanceof ProxyObject) {
            methodHandler = ((ProxyObject)proxy).getHandler();
        } else if (proxy instanceof Proxy) {
            methodHandler = ProxyFactory.getHandler((Proxy)proxy);
        }
        Class<?> clazz2 = clazz;
        return new SerializedProxy(clazz2, ProxyFactory.getFilterSignature(clazz2), methodHandler);
    }

    static class DefaultMethodHandler
    implements MethodHandler,
    Serializable {
        private static final long serialVersionUID = 1L;

        DefaultMethodHandler() {
        }

        @Override
        public Object invoke(Object self, Method m2, Method proceed, Object[] args) throws Exception {
            return proceed.invoke(self, args);
        }
    }
}

