/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.api.BasePipelineListener;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import java.io.PrintStream;

public class RowPipelineListener
extends BasePipelineListener {
    private final int rowIndex;
    private final PrintStream output = System.err;
    private MojoFrame globalFrame;
    private int frameOffset;
    private int frameRowIndex;
    private boolean active;
    private long startTime;

    public RowPipelineListener(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public void onBatchStart(MojoFrame globalFrame) {
        this.globalFrame = globalFrame;
        this.frameRowIndex = this.rowIndex - this.frameOffset;
        boolean bl = this.active = this.frameRowIndex >= 0 && this.frameRowIndex <= globalFrame.getNrows();
        if (this.active) {
            this.output.printf("[TRACKING START: row=%d]%n", this.rowIndex);
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public void onBatchEnd() {
        if (this.active) {
            this.output.printf("[TRACKING END: duration=%d millis]%n", System.currentTimeMillis() - this.startTime);
        }
        this.frameOffset += this.globalFrame.getNrows();
    }

    @Override
    public void onBatchTransform(MojoTransformMeta transformMeta) {
        if (this.active) {
            String string = String.format("%s %s: %-20s", transformMeta.getTransformationGroup(), transformMeta.getId(), transformMeta.getName());
            int[] nArray = transformMeta.getOutputIndices();
            this.output.println(string);
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray2[i2];
                this.output.println("  * " + this.formatResult(n3));
            }
        }
    }

    private String formatResult(int oindex) {
        String string;
        MojoColumnMeta mojoColumnMeta = this.globalFrame.getMeta().getColumns().get(oindex);
        MojoColumn.Type type = mojoColumnMeta.getColumnType();
        try {
            string = this.globalFrame.getColumn(oindex).getDataAsStrings()[this.frameRowIndex];
        }
        catch (Exception exception) {
            string = String.format("{%s: %s}", exception.getClass().getName(), exception.getMessage());
        }
        String string2 = type == MojoColumn.Type.Str ? (string == null ? "null" : "'" + string + "'") : string;
        String string3 = mojoColumnMeta.getColumnName();
        String string4 = string3.contains(" ") ? "'" + string3 + "'" : string3;
        return String.format("%s := %s (%s)", new Object[]{string4, string2, type});
    }

    @Override
    public void onPredictContrib(int[] pcIndices) {
        if (this.active) {
            int[] nArray = pcIndices;
            int n2 = pcIndices.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                String string = this.globalFrame.getColumnName(n3);
                double[] dArray = (double[])this.globalFrame.getColumnData(n3);
                this.output.printf("  > shap: %s := %f%n", string, dArray[this.frameRowIndex]);
            }
        }
    }

    @Override
    public void onScaleApplied(int pcIndex, double scale) {
        String string = this.globalFrame.getColumnName(pcIndex);
        double[] dArray = (double[])this.globalFrame.getColumnData(pcIndex);
        this.output.printf("  %% scaled: %f * %s = %f%n", scale, string, dArray[this.frameRowIndex]);
    }
}

