/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.PipelineLoader;
import ai.h2o.mojos.runtime.api.PipelineLoaderFactory;
import ai.h2o.mojos.runtime.api.backend.DirReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ZipFileReaderBackend;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.utils.Consts;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoPipelineService {
    private static final Logger log = LoggerFactory.getLogger(MojoPipelineService.class);
    private final LinkedHashMap<String, PipelineLoaderFactory> registry = new LinkedHashMap();
    public static MojoPipelineService INSTANCE = new MojoPipelineService(Consts.getSysProp("pipelineFormats", "pbuf,toml,klime,h2o3").split(","));

    private MojoPipelineService(String ... pipelineFormats) {
        Object object;
        LinkedHashMap<String, PipelineLoaderFactory> linkedHashMap = new LinkedHashMap<String, PipelineLoaderFactory>();
        ServiceLoader<PipelineLoaderFactory> serviceLoader = ServiceLoader.load(PipelineLoaderFactory.class, PipelineLoaderFactory.class.getClassLoader());
        for (PipelineLoaderFactory pipelineLoaderFactory : serviceLoader) {
            String string = pipelineLoaderFactory.getName();
            object = linkedHashMap.put(string, pipelineLoaderFactory);
            if (object == null) continue;
            throw new IllegalStateException(String.format("Pipeline loader '%s' is already registered with class '%s'", string, object.getClass().getName()));
        }
        String[] stringArray = pipelineFormats;
        int n2 = pipelineFormats.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = stringArray[i2];
            PipelineLoaderFactory pipelineLoaderFactory = (PipelineLoaderFactory)linkedHashMap.remove(object);
            if (pipelineLoaderFactory != null) {
                this.registry.put((String)object, pipelineLoaderFactory);
                continue;
            }
            log.warn("No pipeline format provider for '{}'%n", object);
        }
        this.registry.putAll(linkedHashMap);
    }

    public PipelineLoaderFactory get(ReaderBackend backend) throws IOException {
        if (this.registry.isEmpty()) {
            throw new IllegalStateException("No pipeline factory is available");
        }
        for (Map.Entry<String, PipelineLoaderFactory> entry : this.registry.entrySet()) {
            PipelineLoaderFactory pipelineLoaderFactory = entry.getValue();
            String string = pipelineLoaderFactory.getRootResource();
            if (!backend.exists(string)) continue;
            return pipelineLoaderFactory;
        }
        throw new IOException(String.format("None of %d available pipeline factories %s can read this mojo.", this.registry.size(), this.registry.keySet()));
    }

    private static ReaderBackend autodetectBackend(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            return DirReaderBackend.open(file);
        }
        if (file.isFile()) {
            return ZipFileReaderBackend.open(file);
        }
        throw new IOException("Unsupported file type: " + file.getAbsolutePath());
    }

    public static MojoPipeline loadPipeline(File file) throws IOException, LicenseException {
        ReaderBackend readerBackend = MojoPipelineService.autodetectBackend(file);
        return MojoPipelineService.loadPipeline(readerBackend);
    }

    public static MojoPipeline loadPipeline(ReaderBackend backend) throws IOException, LicenseException {
        PipelineLoaderFactory pipelineLoaderFactory = INSTANCE.get(backend);
        PipelineLoader pipelineLoader = pipelineLoaderFactory.createLoader(backend, null);
        try {
            Method method = pipelineLoader.getClass().getMethod("load", new Class[0]);
            int n2 = method.getModifiers();
            if (!Modifier.isFinal(n2)) {
                throw new IllegalStateException(String.format("Internal error: Method %s#%s() is required to be declared final", pipelineLoader.getClass().getName(), method.getName()));
            }
            return pipelineLoader.load();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
    }
}

