/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.h2o3.H2O3BackendAdapter;
import ai.h2o.mojos.runtime.h2o3.H2O3PipelineLoader;
import ai.h2o.mojos.runtime.h2o3.KlimeTransform;
import ai.h2o.mojos.runtime.transforms.l;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

class KLimePipelineLoader
extends AbstractPipelineLoader {
    private final List<MojoColumnMeta> globalColumns;
    private final l root;

    public KLimePipelineLoader(ReaderBackend backend) throws IOException {
        super(backend);
        H2O3BackendAdapter h2O3BackendAdapter = new H2O3BackendAdapter(backend);
        MojoModel mojoModel = MojoModel.load(h2O3BackendAdapter);
        EasyPredictModelWrapper easyPredictModelWrapper = H2O3PipelineLoader.wrapModelForPrediction(mojoModel);
        String string = "klime:" + mojoModel.getModelCategory().toString();
        this.globalColumns = new ArrayList<MojoColumnMeta>();
        int[] nArray = KLimePipelineLoader.readInputIndices(this.globalColumns, mojoModel);
        int[] nArray2 = KLimePipelineLoader.readOutputIndices(this.globalColumns, mojoModel);
        MojoFrameMeta mojoFrameMeta = new MojoFrameMeta(this.globalColumns);
        String string2 = String.format("algo: %s, balanceClasses: %s, attributes: %s, default threshold: %s", mojoModel._algoName, mojoModel._balanceClasses, mojoModel._modelAttributes, mojoModel._defaultThreshold);
        MojoTransformMeta mojoTransformMeta = new MojoTransformMeta(string, string2, nArray, nArray2, "klime-main", 0, null);
        KlimeTransform klimeTransform = new KlimeTransform(mojoFrameMeta, nArray, nArray2, easyPredictModelWrapper);
        klimeTransform.setId("klime-main");
        klimeTransform.setName(string);
        mojoTransformMeta.setTransform(klimeTransform);
        DateTime dateTime = new DateTime(1970, 1, 1, 0, 0);
        MojoPipelineMeta mojoPipelineMeta = new MojoPipelineMeta(mojoModel.getUUID(), dateTime);
        new MojoPipelineMeta(mojoModel.getUUID(), dateTime).license = "H2O-3 Opensource";
        this.root = new l(mojoFrameMeta, nArray, nArray2, Collections.singletonList(mojoTransformMeta), mojoPipelineMeta);
    }

    @Override
    public List<MojoColumnMeta> getColumns() {
        return this.globalColumns;
    }

    @Override
    public List<MojoTransformMeta> getTransformations() {
        return this.root.a;
    }

    @Override
    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(this.globalColumns, this.root);
    }

    static int[] readInputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        int[] nArray = new int[genModel.getNumCols()];
        for (int i2 = 0; i2 < genModel.getNumCols(); ++i2) {
            String string = genModel.getNames()[i2];
            MojoColumn.Type type = genModel.getDomainValues(i2) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            nArray[i2] = columns.size();
            columns.add(MojoColumnMeta.newInput(string, type));
        }
        return nArray;
    }

    private static int[] readOutputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(genModel.getNames()));
        arrayList.remove(genModel.getResponseName());
        String[] stringArray = arrayList.toArray(new String[0]);
        int n2 = genModel.getPredsSize();
        int[] nArray = new int[n2];
        int[] nArray2 = nArray;
        nArray[0] = columns.size();
        columns.add(MojoColumnMeta.newOutput(genModel.getResponseName(), MojoColumn.Type.Float64));
        nArray2[1] = columns.size();
        columns.add(MojoColumnMeta.newOutput("cluster", MojoColumn.Type.Float64));
        for (int i2 = 2; i2 < n2; ++i2) {
            nArray2[i2] = columns.size();
            String string = "rc_" + stringArray[i2 - 2];
            columns.add(MojoColumnMeta.newOutput(string, MojoColumn.Type.Float64));
        }
        return nArray2;
    }
}

