/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.AccumulateCsvResults;
import com.opencsv.bean.concurrent.IntolerantThreadPoolExecutor;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.concurrent.ProcessCsvLine;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;

public class CsvToBean<T>
implements Iterable<T> {
    private List<CsvException> capturedExceptions = null;
    private MappingStrategy<T> mappingStrategy;
    private CSVReader csvReader;
    private CsvToBeanFilter filter = null;
    private boolean throwExceptions = true;
    private boolean orderedResults = true;
    private long lineProcessed;
    private String[] line;
    private IntolerantThreadPoolExecutor executor;
    private AccumulateCsvResults accumulateThread = null;
    private BlockingQueue<OrderedObject<T>> resultantBeansQueue;
    private BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private ConcurrentNavigableMap<Long, T> resultantBeansMap = null;
    private ConcurrentNavigableMap<Long, CsvException> thrownExceptionsMap = null;
    private Locale errorLocale = Locale.getDefault();

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, Reader reader) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReaderBuilder(reader).withErrorLocale(this.errorLocale).build());
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, Reader reader, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReaderBuilder(reader).withErrorLocale(this.errorLocale).build());
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReaderBuilder(reader).withErrorLocale(this.errorLocale).build());
        this.setFilter(filter);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReaderBuilder(reader).withErrorLocale(this.errorLocale).build());
        this.setFilter(filter);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setFilter(filter);
        return this.parse();
    }

    @Deprecated
    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setFilter(filter);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    private void prepareForParallelProcessing() {
        this.executor = new IntolerantThreadPoolExecutor();
        this.executor.prestartAllCoreThreads();
        this.resultantBeansQueue = new LinkedBlockingQueue<OrderedObject<T>>();
        this.thrownExceptionsQueue = new LinkedBlockingQueue<OrderedObject<CsvException>>();
        if (this.orderedResults) {
            this.resultantBeansMap = new ConcurrentSkipListMap<Long, T>();
            this.thrownExceptionsMap = new ConcurrentSkipListMap<Long, CsvException>();
            this.accumulateThread = new AccumulateCsvResults<T>(this.resultantBeansQueue, this.thrownExceptionsQueue, this.resultantBeansMap, this.thrownExceptionsMap);
            this.accumulateThread.start();
        }
    }

    private void submitAllBeans() throws IOException, InterruptedException {
        while (null != (this.line = this.csvReader.readNext())) {
            ++this.lineProcessed;
            this.executor.execute(new ProcessCsvLine<T>(this.lineProcessed, this.mappingStrategy, this.filter, this.line, this.resultantBeansQueue, this.thrownExceptionsQueue, this.throwExceptions));
        }
        this.executor.shutdown();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        if (this.accumulateThread != null) {
            this.accumulateThread.setMustStop(true);
            this.accumulateThread.join();
        }
        if (this.executor.getTerminalException() != null) {
            throw new RejectedExecutionException();
        }
    }

    private List<T> prepareResults() {
        ArrayList<Object> arrayList;
        if (this.thrownExceptionsMap != null && this.resultantBeansMap != null) {
            this.capturedExceptions = new ArrayList(this.thrownExceptionsMap.values());
            arrayList = new ArrayList(this.resultantBeansMap.values());
        } else {
            this.capturedExceptions = new ArrayList<CsvException>(this.thrownExceptionsQueue.size());
            while (!this.thrownExceptionsQueue.isEmpty()) {
                OrderedObject orderedObject = (OrderedObject)this.thrownExceptionsQueue.poll();
                if (orderedObject == null) continue;
                this.capturedExceptions.add((CsvException)orderedObject.getElement());
            }
            arrayList = new ArrayList(this.resultantBeansQueue.size());
            while (!this.resultantBeansQueue.isEmpty()) {
                OrderedObject orderedObject = (OrderedObject)this.resultantBeansQueue.poll();
                if (orderedObject == null) continue;
                arrayList.add(orderedObject.getElement());
            }
        }
        return arrayList;
    }

    public List<T> parse() throws IllegalStateException {
        this.prepareToReadInput();
        this.prepareForParallelProcessing();
        try {
            this.submitAllBeans();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (this.accumulateThread != null) {
                this.accumulateThread.setMustStop(true);
            }
            throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error"), this.lineProcessed, Arrays.toString(this.line)), this.executor.getTerminalException());
        }
        catch (Exception exception) {
            this.executor.shutdownNow();
            if (this.accumulateThread != null) {
                this.accumulateThread.setMustStop(true);
            }
            throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error"), this.lineProcessed, Arrays.toString(this.line)), exception);
        }
        return this.prepareResults();
    }

    public List<CsvException> getCapturedExceptions() {
        if (this.capturedExceptions == null) {
            this.capturedExceptions = new ArrayList<CsvException>();
        }
        return this.capturedExceptions;
    }

    public void setMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public void setCsvReader(CSVReader csvReader) {
        this.csvReader = csvReader;
    }

    public void setFilter(CsvToBeanFilter filter) {
        this.filter = filter;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public void setOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    private void prepareToReadInput() throws IllegalStateException {
        if (this.mappingStrategy == null || this.csvReader == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("specify.strategy.reader"));
        }
        try {
            this.mappingStrategy.captureHeader(this.csvReader);
        }
        catch (Exception exception) {
            throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.error"), exception);
        }
        this.lineProcessed = 0L;
        this.line = null;
    }

    @Override
    public Iterator<T> iterator() {
        this.prepareToReadInput();
        return new CsvToBeanIterator();
    }

    static /* synthetic */ String[] access$302(CsvToBean x0, String[] x1) {
        x0.line = x1;
        return x1;
    }

    private class CsvToBeanIterator
    implements Iterator {
        private T bean;

        public CsvToBeanIterator() {
            CsvToBean.this.resultantBeansQueue = new ArrayBlockingQueue(1);
            CsvToBean.this.thrownExceptionsQueue = new ArrayBlockingQueue(1);
            this.readSingleLine();
        }

        private void processException() {
            OrderedObject orderedObject = (OrderedObject)CsvToBean.this.thrownExceptionsQueue.poll();
            if (orderedObject != null && orderedObject.getElement() != null) {
                if (CsvToBean.this.capturedExceptions == null) {
                    CsvToBean.this.capturedExceptions = new ArrayList();
                }
                CsvToBean.this.capturedExceptions.add(orderedObject.getElement());
            }
        }

        private void readLineWithPossibleError() throws IOException {
            this.bean = null;
            while (this.bean == null && null != CsvToBean.access$302(CsvToBean.this, CsvToBean.this.csvReader.readNext())) {
                CsvToBean.this.lineProcessed++;
                ProcessCsvLine processCsvLine = new ProcessCsvLine(CsvToBean.this.lineProcessed, CsvToBean.this.mappingStrategy, CsvToBean.this.filter, CsvToBean.this.line, CsvToBean.this.resultantBeansQueue, CsvToBean.this.thrownExceptionsQueue, CsvToBean.this.throwExceptions);
                processCsvLine.run();
                if (!CsvToBean.this.thrownExceptionsQueue.isEmpty()) {
                    this.processException();
                    continue;
                }
                OrderedObject orderedObject = (OrderedObject)CsvToBean.this.resultantBeansQueue.poll();
                this.bean = orderedObject == null ? null : orderedObject.getElement();
            }
            if (CsvToBean.this.line == null) {
                this.bean = null;
            }
        }

        private void readSingleLine() {
            try {
                this.readLineWithPossibleError();
                return;
            }
            catch (IOException iOException) {
                CsvToBean.access$302(CsvToBean.this, null);
                throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", CsvToBean.this.errorLocale).getString("parsing.error"), CsvToBean.this.lineProcessed, Arrays.toString(CsvToBean.this.line)), iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.bean != null;
        }

        public T next() {
            if (this.bean == null) {
                throw new NoSuchElementException();
            }
            Object t2 = this.bean;
            this.readSingleLine();
            return t2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", CsvToBean.this.errorLocale).getString("read.only.iterator"));
        }
    }
}

