/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.FolderMojoReaderBackend;
import hex.genmodel.InMemoryMojoReaderBackend;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.TmpMojoReaderBackend;
import hex.genmodel.ZipfileMojoReaderBackend;
import hex.genmodel.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MojoReaderBackendFactory {
    public static MojoReaderBackend createReaderBackend(String filename) throws IOException {
        return MojoReaderBackendFactory.createReaderBackend(new File(filename));
    }

    public static MojoReaderBackend createReaderBackend(File file) throws IOException {
        if (file.isFile()) {
            return new ZipfileMojoReaderBackend(file.getPath());
        }
        if (file.isDirectory()) {
            return new FolderMojoReaderBackend(file.getPath());
        }
        throw new IOException("Invalid file specification: " + file);
    }

    public static MojoReaderBackend createReaderBackend(URL url, CachingStrategy cachingStrategy) throws IOException {
        MojoReaderBackend mojoReaderBackend;
        block9: {
            InputStream inputStream = url.openStream();
            Throwable throwable = null;
            try {
                mojoReaderBackend = MojoReaderBackendFactory.createReaderBackend(inputStream, cachingStrategy);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                    throw throwable4;
                }
            }
            inputStream.close();
        }
        return mojoReaderBackend;
    }

    public static MojoReaderBackend createReaderBackend(InputStream inputStream, CachingStrategy cachingStrategy) throws IOException {
        switch (cachingStrategy) {
            case MEMORY: {
                return MojoReaderBackendFactory.createInMemoryReaderBackend(inputStream);
            }
            case DISK: {
                return MojoReaderBackendFactory.createTempFileReaderBackend(inputStream);
            }
        }
        throw new IllegalStateException("Unexpected caching strategy: " + (Object)((Object)cachingStrategy));
    }

    private static MojoReaderBackend createInMemoryReaderBackend(InputStream inputStream) throws IOException {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("File too large: " + zipEntry.getName());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copyStream(zipInputStream, byteArrayOutputStream);
                hashMap.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
            }
            zipInputStream.close();
        }
        finally {
            MojoReaderBackendFactory.closeQuietly(zipInputStream);
        }
        return new InMemoryMojoReaderBackend(hashMap);
    }

    private static MojoReaderBackend createTempFileReaderBackend(InputStream inputStream) throws IOException {
        File file = File.createTempFile("h2o-mojo", ".zip");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            IOUtils.copyStream(inputStream, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            IOException iOException2;
            MojoReaderBackendFactory.closeQuietly(fileOutputStream);
            if (!file.delete()) {
                iOException2 = new IOException(iOException.getMessage() + " [Note: temp file " + file + " not deleted]", iOException);
            }
            throw iOException2;
        }
        finally {
            MojoReaderBackendFactory.closeQuietly(fileOutputStream);
        }
        return new TmpMojoReaderBackend(file);
    }

    private static void closeQuietly(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static enum CachingStrategy {
        MEMORY,
        DISK;

    }
}

