/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

public class GamUtilsThinPlateRegression {
    public static double calTPConstantTerm(int m2, int d2, boolean dEven) {
        if (dEven) {
            return Math.pow(-1.0, (double)(m2 + 1) + (double)d2 / 2.0) / (Math.pow(2.0, 2 * m2 - 1) * Math.pow(Math.PI, (double)d2 / 2.0) * (double)GamUtilsThinPlateRegression.factorial(m2 - 1) * (double)GamUtilsThinPlateRegression.factorial(m2 - d2 / 2));
        }
        return Math.pow(-1.0, m2) * (double)m2 / ((double)GamUtilsThinPlateRegression.factorial(2 * m2) * Math.pow(Math.PI, (double)(d2 - 1) / 2.0));
    }

    public static int factorial(int m2) {
        if (m2 <= 1) {
            return 1;
        }
        int n2 = 1;
        for (int i2 = 1; i2 <= m2; ++i2) {
            n2 *= i2;
        }
        return n2;
    }

    public static void calculateDistance(double[] rowValues, double[] chk, int knotNum, double[][] knots, int d2, int m2, boolean dEven, double constantTerms, double[] oneOGamColStd, boolean standardizeGAM) {
        for (int i2 = 0; i2 < knotNum; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < d2; ++i3) {
                double d4;
                double d5 = d4 = standardizeGAM ? (chk[i3] - knots[i3][i2]) * oneOGamColStd[i3] : chk[i3] - knots[i3][i2];
                d3 += d5 * d5;
            }
            double d6 = Math.pow(Math.sqrt(d3), 2 * m2 - d2);
            rowValues[i2] = constantTerms * d6;
            if (!dEven || d6 == 0.0) continue;
            int n2 = i2;
            rowValues[n2] = rowValues[n2] * Math.log(d6);
        }
    }

    public static void calculatePolynomialBasis(double[] onePolyRow, double[] oneDataRow, int d2, int M2, int[][] polyBasisList, double[] gamColMean, double[] oneOGamStd, boolean standardizeGAM) {
        for (int i2 = 0; i2 < M2; ++i2) {
            int[] nArray = polyBasisList[i2];
            double d3 = 1.0;
            for (int i3 = 0; i3 < d2; ++i3) {
                d3 *= standardizeGAM ? Math.pow(oneDataRow[i3] - gamColMean[i3] * oneOGamStd[i3], nArray[i3]) : Math.pow(oneDataRow[i3], nArray[i3]);
            }
            onePolyRow[i2] = d3;
        }
    }
}

