/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.glrm.GlrmRegularizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GlrmMojoReader
extends ModelMojoReader<GlrmMojoModel> {
    @Override
    public String getModelName() {
        return "Generalized Low Rank Model";
    }

    @Override
    protected void readModelData() throws IOException {
        block8: {
            int n2;
            ((GlrmMojoModel)this._model)._ncolA = (Integer)this.readkv("ncolA");
            ((GlrmMojoModel)this._model)._ncolY = (Integer)this.readkv("ncolY");
            ((GlrmMojoModel)this._model)._nrowY = (Integer)this.readkv("nrowY");
            ((GlrmMojoModel)this._model)._ncolX = (Integer)this.readkv("ncolX");
            ((GlrmMojoModel)this._model)._regx = GlrmRegularizer.valueOf((String)this.readkv("regularizationX"));
            ((GlrmMojoModel)this._model)._gammax = (Double)this.readkv("gammaX");
            ((GlrmMojoModel)this._model)._init = GlrmInitialization.valueOf((String)this.readkv("initialization"));
            ((GlrmMojoModel)this._model)._ncats = (Integer)this.readkv("num_categories");
            ((GlrmMojoModel)this._model)._nnums = (Integer)this.readkv("num_numeric");
            ((GlrmMojoModel)this._model)._normSub = (double[])this.readkv("norm_sub");
            ((GlrmMojoModel)this._model)._normMul = (double[])this.readkv("norm_mul");
            ((GlrmMojoModel)this._model)._permutation = (int[])this.readkv("cols_permutation");
            ((GlrmMojoModel)this._model)._losses = new GlrmLoss[((GlrmMojoModel)this._model)._ncolA];
            int n3 = 0;
            for (String string : this.readtext("losses")) {
                ((GlrmMojoModel)this._model)._losses[n3++] = GlrmLoss.valueOf(string);
            }
            ((GlrmMojoModel)this._model)._numLevels = (int[])this.readkv("num_levels_per_category");
            ((GlrmMojoModel)this._model)._archetypes = new double[((GlrmMojoModel)this._model)._nrowY][];
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob("archetypes"));
            for (n2 = 0; n2 < ((GlrmMojoModel)this._model)._nrowY; ++n2) {
                double[] dArray = new double[((GlrmMojoModel)this._model)._ncolY];
                ((GlrmMojoModel)this._model)._archetypes[n2] = dArray;
                for (int i2 = 0; i2 < ((GlrmMojoModel)this._model)._ncolY; ++i2) {
                    dArray[i2] = byteBuffer.getDouble();
                }
            }
            try {
                ((GlrmMojoModel)this._model)._seed = this.readkv("seed", 0L);
                ((GlrmMojoModel)this._model)._reverse_transform = (Boolean)this.readkv("reverse_transform");
                ((GlrmMojoModel)this._model)._transposed = (Boolean)this.readkv("transposed");
                ((GlrmMojoModel)this._model)._catOffsets = (int[])this.readkv("catOffsets");
                if (((GlrmMojoModel)this._model)._transposed) {
                    ((GlrmMojoModel)this._model)._archetypes_raw = new double[((GlrmMojoModel)this._model)._archetypes[0].length][((GlrmMojoModel)this._model)._archetypes.length];
                    for (n2 = 0; n2 < ((GlrmMojoModel)this._model)._archetypes.length; ++n2) {
                        for (int i3 = 0; i3 < ((GlrmMojoModel)this._model)._archetypes[0].length; ++i3) {
                            ((GlrmMojoModel)this._model)._archetypes_raw[i3][n2] = ((GlrmMojoModel)this._model)._archetypes[n2][i3];
                        }
                    }
                    break block8;
                }
                ((GlrmMojoModel)this._model)._archetypes_raw = ((GlrmMojoModel)this._model)._archetypes;
                return;
            }
            catch (NullPointerException nullPointerException) {
                ((GlrmMojoModel)this._model)._seed = System.currentTimeMillis();
                ((GlrmMojoModel)this._model)._reverse_transform = true;
                ((GlrmMojoModel)this._model)._transposed = true;
                ((GlrmMojoModel)this._model)._catOffsets = null;
                ((GlrmMojoModel)this._model)._archetypes_raw = null;
            }
        }
    }

    @Override
    protected GlrmMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        GlrmMojoModel glrmMojoModel = new GlrmMojoModel(columns, domains, responseColumn);
        new GlrmMojoModel(columns, domains, responseColumn)._allAlphas = GlrmMojoModel.initializeAlphas(glrmMojoModel._numAlphaFactors);
        return glrmMojoModel;
    }

    @Override
    public String mojoVersion() {
        return "1.10";
    }
}

