/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.algos.psvm.SupportVectorScorer;
import hex.genmodel.utils.ByteBufferWrapper;

class GaussianScorer
implements SupportVectorScorer {
    private final double _gamma;
    private final byte[] _svs;

    GaussianScorer(KernelParameters parms, byte[] svs) {
        this(parms._gamma, svs);
    }

    GaussianScorer(double gamma, byte[] svs) {
        this._gamma = gamma;
        this._svs = svs;
    }

    @Override
    public double score0(double[] row) {
        double d2 = 0.0;
        ByteBufferWrapper byteBufferWrapper = new ByteBufferWrapper(this._svs);
        while (byteBufferWrapper.hasRemaining()) {
            int n2;
            double d3 = byteBufferWrapper.get8d();
            double d4 = 0.0;
            int n3 = byteBufferWrapper.get4();
            for (n2 = 0; n2 < n3; ++n2) {
                d4 += (int)row[n2] == byteBufferWrapper.get4() ? 0.0 : 2.0;
            }
            n2 = byteBufferWrapper.get4();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d5;
                double d6 = d5 = row[i2 + n3] - byteBufferWrapper.get8d();
                d4 += d6 * d6;
            }
            d2 += d3 * Math.exp(-this._gamma * d4);
        }
        return d2;
    }
}

