/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Predicate predicate;

    public BeanPredicate(String propertyName, Predicate predicate) {
        this.propertyName = propertyName;
        this.predicate = predicate;
    }

    @Override
    public boolean evaluate(Object object) {
        boolean evaluation;
        try {
            Object object2 = PropertyUtils.getProperty(object, this.propertyName);
            evaluation = this.predicate.evaluate(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.error("ERROR: Problem during evaluation.", illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.error("Unable to access the property provided.", illegalAccessException);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException invocationTargetException) {
            this.log.error("Exception occurred in property's getter", invocationTargetException);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log.error("Property not found.", noSuchMethodException);
            throw new IllegalArgumentException("Property not found.");
        }
        return evaluation;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }
}

