/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public abstract class NumberConverter
extends AbstractConverter {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private String pattern;
    private final boolean allowDecimals;
    private boolean useLocaleFormat;
    private Locale locale;

    public NumberConverter(boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
    }

    public NumberConverter(boolean allowDecimals, Object defaultValue) {
        this.allowDecimals = allowDecimals;
        this.setDefaultValue(defaultValue);
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.setUseLocaleFormat(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    @Override
    protected String convertToString(Object value) throws Throwable {
        String result;
        if (this.useLocaleFormat && value instanceof Number) {
            NumberFormat numberFormat = this.getFormat();
            numberFormat.setGroupingUsed(false);
            result = numberFormat.format(value);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using format '" + result + "'");
            }
        } else {
            result = value.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using toString() '" + result + "'");
            }
        }
        return result;
    }

    @Override
    protected <T> T convertToType(Class<T> targetType, Object value) throws Throwable {
        Number number;
        Class<?> clazz = value.getClass();
        if (value instanceof Number) {
            return this.toNumber(clazz, targetType, (Number)value);
        }
        if (value instanceof Boolean) {
            return this.toNumber(clazz, targetType, (Boolean)value != false ? ONE : ZERO);
        }
        if (value instanceof Date && Long.class.equals(targetType)) {
            return targetType.cast(new Long(((Date)value).getTime()));
        }
        if (value instanceof Calendar && Long.class.equals(targetType)) {
            return targetType.cast(new Long(((Calendar)value).getTime().getTime()));
        }
        String string = value.toString().trim();
        if (string.length() == 0) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            NumberFormat numberFormat = this.getFormat();
            number = this.parse(clazz, targetType, string, numberFormat);
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    No NumberFormat, using default conversion");
            }
            number = this.toNumber(clazz, targetType, string);
        }
        return this.toNumber(clazz, targetType, number);
    }

    private <T> T toNumber(Class<?> sourceType, Class<T> targetType, Number value) {
        if (targetType.equals(value.getClass())) {
            return targetType.cast(value);
        }
        if (targetType.equals(Byte.class)) {
            long l2 = value.longValue();
            if (l2 > 127L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too large for " + this.toString(targetType));
            }
            if (l2 < -128L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Byte(value.byteValue()));
        }
        if (targetType.equals(Short.class)) {
            long l3 = value.longValue();
            if (l3 > 32767L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too large for " + this.toString(targetType));
            }
            if (l3 < -32768L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Short(value.shortValue()));
        }
        if (targetType.equals(Integer.class)) {
            long l4 = value.longValue();
            if (l4 > Integer.MAX_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too large for " + this.toString(targetType));
            }
            if (l4 < Integer.MIN_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Integer(value.intValue()));
        }
        if (targetType.equals(Long.class)) {
            return targetType.cast(new Long(value.longValue()));
        }
        if (targetType.equals(Float.class)) {
            if (value.doubleValue() > 3.4028234663852886E38) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value + "' is too large for " + this.toString(targetType));
            }
            return targetType.cast(new Float(value.floatValue()));
        }
        if (targetType.equals(Double.class)) {
            return targetType.cast(new Double(value.doubleValue()));
        }
        if (targetType.equals(BigDecimal.class)) {
            if (value instanceof Float || value instanceof Double) {
                return targetType.cast(new BigDecimal(value.toString()));
            }
            if (value instanceof BigInteger) {
                return targetType.cast(new BigDecimal((BigInteger)value));
            }
            if (value instanceof BigDecimal) {
                return targetType.cast(new BigDecimal(value.toString()));
            }
            return targetType.cast(BigDecimal.valueOf(value.longValue()));
        }
        if (targetType.equals(BigInteger.class)) {
            if (value instanceof BigDecimal) {
                return targetType.cast(((BigDecimal)value).toBigInteger());
            }
            return targetType.cast(BigInteger.valueOf(value.longValue()));
        }
        NumberConverter numberConverter = this;
        String string = numberConverter.toString(numberConverter.getClass()) + " cannot handle conversion to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + string);
        }
        throw new ConversionException(string);
    }

    private Number toNumber(Class<?> sourceType, Class<?> targetType, String value) {
        if (targetType.equals(Byte.class)) {
            return new Byte(value);
        }
        if (targetType.equals(Short.class)) {
            return new Short(value);
        }
        if (targetType.equals(Integer.class)) {
            return new Integer(value);
        }
        if (targetType.equals(Long.class)) {
            return new Long(value);
        }
        if (targetType.equals(Float.class)) {
            return new Float(value);
        }
        if (targetType.equals(Double.class)) {
            return new Double(value);
        }
        if (targetType.equals(BigDecimal.class)) {
            return new BigDecimal(value);
        }
        if (targetType.equals(BigInteger.class)) {
            return new BigInteger(value);
        }
        NumberConverter numberConverter = this;
        String string = numberConverter.toString(numberConverter.getClass()) + " cannot handle conversion from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + string);
        }
        throw new ConversionException(string);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        NumberConverter numberConverter = this;
        stringBuilder.append(numberConverter.toString(numberConverter.getClass()));
        stringBuilder.append("[UseDefault=");
        stringBuilder.append(this.isUseDefault());
        stringBuilder.append(", UseLocaleFormat=");
        stringBuilder.append(this.useLocaleFormat);
        if (this.pattern != null) {
            stringBuilder.append(", Pattern=");
            stringBuilder.append(this.pattern);
        }
        if (this.locale != null) {
            stringBuilder.append(", Locale=");
            stringBuilder.append(this.locale);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private NumberFormat getFormat() {
        NumberFormat numberFormat;
        if (this.pattern != null) {
            if (this.locale == null) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    Using pattern '" + this.pattern + "'");
                }
                numberFormat = new DecimalFormat(this.pattern);
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    Using pattern '" + this.pattern + "' with Locale[" + this.locale + "]");
                }
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
                numberFormat = new DecimalFormat(this.pattern, decimalFormatSymbols);
            }
        } else if (this.locale == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default Locale format");
            }
            numberFormat = NumberFormat.getInstance();
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using Locale[" + this.locale + "] format");
            }
            numberFormat = NumberFormat.getInstance(this.locale);
        }
        if (!this.allowDecimals) {
            numberFormat.setParseIntegerOnly(true);
        }
        return numberFormat;
    }

    private Number parse(Class<?> sourceType, Class<?> targetType, String value, NumberFormat format) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = format.parse(value, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() != value.length() || number == null) {
            String string = "Error converting from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format instanceof DecimalFormat) {
                string = string + " using pattern '" + ((DecimalFormat)format).toPattern() + "'";
            }
            if (this.locale != null) {
                string = string + " for locale=[" + this.locale + "]";
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    " + string);
            }
            throw new ConversionException(string);
        }
        return number;
    }
}

