/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateLocaleConverter
extends BaseLocaleConverter {
    private final Log log = LogFactory.getLog(DateLocaleConverter.class);
    boolean isLenient = false;
    private static final String DEFAULT_PATTERN_CHARS = DateLocaleConverter.initDefaultChars();

    public DateLocaleConverter() {
        this(false);
    }

    public DateLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DateLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, null, locPattern);
    }

    public DateLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public DateLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public DateLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public DateLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        this.isLenient = lenient;
    }

    @Override
    protected Object parse(Object value, String pattern) throws ParseException {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (this.locPattern) {
            pattern = this.convertLocalizedPattern(pattern, this.locale);
        }
        DateFormat dateFormat = pattern == null ? DateFormat.getDateInstance(3, this.locale) : new SimpleDateFormat(pattern, this.locale);
        dateFormat.setLenient(this.isLenient);
        ParsePosition parsePosition = new ParsePosition(0);
        String string = value.toString();
        Object object = dateFormat.parseObject(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0) {
            throw new ConversionException("Error parsing date '" + value + "' at position=" + parsePosition.getErrorIndex());
        }
        if (parsePosition.getIndex() < string.length()) {
            throw new ConversionException("Date '" + value + "' contains unparsed characters from position=" + parsePosition.getIndex());
        }
        return object;
    }

    private String convertLocalizedPattern(String localizedPattern, Locale locale) {
        if (localizedPattern == null) {
            return null;
        }
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String string = dateFormatSymbols.getLocalPatternChars();
        if (DEFAULT_PATTERN_CHARS.equals(string)) {
            return localizedPattern;
        }
        String string2 = null;
        try {
            string2 = this.convertPattern(localizedPattern, string, DEFAULT_PATTERN_CHARS);
        }
        catch (Exception exception) {
            this.log.debug("Converting pattern '" + localizedPattern + "' for " + locale, exception);
        }
        return string2;
    }

    private String convertPattern(String pattern, String fromChars, String toChars) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char c2 = pattern.charAt(i2);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                }
            } else if (c2 == '\'') {
                bl = true;
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                int n2 = fromChars.indexOf(c2);
                if (n2 == -1) {
                    throw new IllegalArgumentException("Illegal pattern character '" + c2 + "'");
                }
                c2 = toChars.charAt(n2);
            }
            stringBuilder.append(c2);
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuilder.toString();
    }

    private static String initDefaultChars() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.US);
        return dateFormatSymbols.getLocalPatternChars();
    }
}

