/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.HashBag;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.set.UnmodifiableSet;

public abstract class DefaultMapBag
implements Bag {
    private Map _map = null;
    private int _total = 0;
    private int _mods = 0;

    public DefaultMapBag() {
    }

    protected DefaultMapBag(Map map) {
        this.setMap(map);
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int nCopies) {
        ++this._mods;
        if (nCopies > 0) {
            int n2 = nCopies + this.getCount(object);
            this._map.put(object, n2);
            this._total += nCopies;
            return n2 == nCopies;
        }
        return false;
    }

    public boolean addAll(Collection coll) {
        boolean bl = false;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = this.add(iterator.next());
            bl = bl || bl2;
        }
        return bl;
    }

    public void clear() {
        ++this._mods;
        this._map.clear();
        this._total = 0;
    }

    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    public boolean containsAll(Collection coll) {
        return this.containsAll(new HashBag(coll));
    }

    public boolean containsAll(Bag other) {
        boolean bl = true;
        Iterator iterator = other.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            boolean bl2 = this.getCount(e2) >= other.getCount(e2);
            bl = bl && bl2;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)object;
        if (bag.size() != this.size()) {
            return false;
        }
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (bag.getCount(k2) == this.getCount(k2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Iterator iterator() {
        DefaultMapBag defaultMapBag = this;
        return new BagIterator(defaultMapBag, defaultMapBag.extractList().iterator());
    }

    public boolean remove(Object object) {
        return this.remove(object, this.getCount(object));
    }

    public boolean remove(Object object, int nCopies) {
        boolean bl;
        ++this._mods;
        int n2 = this.getCount(object);
        if (nCopies <= 0) {
            bl = false;
        } else if (n2 > nCopies) {
            this._map.put(object, new Integer(n2 - nCopies));
            bl = true;
            this._total -= nCopies;
        } else {
            bl = this._map.remove(object) != null;
            this._total -= n2;
        }
        return bl;
    }

    public boolean removeAll(Collection coll) {
        boolean bl = false;
        if (coll != null) {
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = this.remove(iterator.next(), 1);
                bl = bl || bl2;
            }
        }
        return bl;
    }

    public boolean retainAll(Collection coll) {
        return this.retainAll(new HashBag(coll));
    }

    public boolean retainAll(Bag other) {
        boolean bl = false;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            int n3 = other.getCount(e2);
            if (n3 > 0 && n3 <= n2) {
                hashBag.add(e2, n2 - n3);
                continue;
            }
            hashBag.add(e2, n2);
        }
        if (!hashBag.isEmpty()) {
            bl = this.removeAll((Collection)hashBag);
        }
        return bl;
    }

    public Object[] toArray() {
        return this.extractList().toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.extractList().toArray(array);
    }

    public int getCount(Object object) {
        int n2 = 0;
        Integer n3 = MapUtils.getInteger(this._map, object);
        if (n3 != null) {
            n2 = n3;
        }
        return n2;
    }

    public Set uniqueSet() {
        return UnmodifiableSet.decorate(this._map.keySet());
    }

    public int size() {
        return this._total;
    }

    protected int calcTotalSize() {
        this._total = this.extractList().size();
        return this._total;
    }

    protected void setMap(Map map) {
        if (map == null || !map.isEmpty()) {
            throw new IllegalArgumentException("The map must be non-null and empty");
        }
        this._map = map;
    }

    protected Map getMap() {
        return this._map;
    }

    private List extractList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            for (int i2 = this.getCount(e2); i2 > 0; --i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    private int modCount() {
        return this._mods;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            stringBuffer.append(n2);
            stringBuffer.append(":");
            stringBuffer.append(e2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static int access$000(DefaultMapBag x0) {
        return x0.modCount();
    }

    static class BagIterator
    implements Iterator {
        private DefaultMapBag _parent = null;
        private Iterator _support = null;
        private Object _current = null;
        private int _mods = 0;

        public BagIterator(DefaultMapBag parent, Iterator support) {
            this._parent = parent;
            this._support = support;
            this._current = null;
            this._mods = DefaultMapBag.access$000(parent);
        }

        public boolean hasNext() {
            return this._support.hasNext();
        }

        public Object next() {
            if (DefaultMapBag.access$000(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._current = this._support.next();
            return this._current;
        }

        public void remove() {
            if (DefaultMapBag.access$000(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._support.remove();
            this._parent.remove(this._current, 1);
            ++this._mods;
        }
    }
}

