/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtendedProperties
extends Hashtable {
    private ExtendedProperties defaults;
    protected String file;
    protected String basePath;
    protected String fileSeparator;
    protected boolean isInitialized;
    protected static String include = "include";
    protected ArrayList keysAsListed;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    protected String interpolate(String base) {
        return this.interpolateHelper(base, null);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        int n2;
        int n3;
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int n4 = 0 - 1;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n3 = base.indexOf(START_TOKEN, n4 + 1)) >= 0 && (n2 = base.indexOf(END_TOKEN, n3)) >= 0) {
            Object object;
            stringBuffer.append(base.substring(n4 + 1, n3));
            String string = base.substring(n3 + 2, n2);
            if (priorVariables.contains(string)) {
                object = priorVariables.remove(0).toString();
                priorVariables.add(string);
                StringBuffer stringBuffer2 = new StringBuffer();
                Iterator iterator = priorVariables.iterator();
                while (iterator.hasNext()) {
                    stringBuffer2.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuffer2.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + (String)object + ": " + stringBuffer2.toString());
            }
            priorVariables.add(string);
            object = this.getProperty(string);
            if (object != null) {
                stringBuffer.append(this.interpolateHelper(object.toString(), priorVariables));
                ArrayList<String> arrayList = priorVariables;
                arrayList.remove(arrayList.size() - 1);
            } else if (this.defaults != null && this.defaults.getString(string, null) != null) {
                stringBuffer.append(this.defaults.getString(string));
            } else {
                stringBuffer.append(START_TOKEN).append(string).append(END_TOKEN);
            }
            n4 = n2;
        }
        stringBuffer.append(base.substring(n4 + 1, base.length()));
        return stringBuffer.toString();
    }

    private static String escape(String s2) {
        StringBuffer stringBuffer = new StringBuffer(s2);
        for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            char c2 = stringBuffer.charAt(i2);
            if (c2 != ',' && c2 != '\\') continue;
            stringBuffer.insert(i2, '\\');
            ++i2;
        }
        return stringBuffer.toString();
    }

    private static String unescape(String s2) {
        StringBuffer stringBuffer = new StringBuffer(s2);
        for (int i2 = 0; i2 < stringBuffer.length() - 1; ++i2) {
            char c2 = stringBuffer.charAt(i2);
            char c3 = stringBuffer.charAt(i2 + 1);
            if (c2 != '\\' || c3 != '\\') continue;
            stringBuffer.deleteCharAt(i2);
        }
        return stringBuffer.toString();
    }

    private static int countPreceding(String line, int index, char ch) {
        int n2;
        for (n2 = index - 1; n2 >= 0 && line.charAt(n2) == ch; --n2) {
        }
        return index - 1 - n2;
    }

    private static boolean endsWithSlash(String line) {
        if (!line.endsWith("\\")) {
            return false;
        }
        String string = line;
        return ExtendedProperties.countPreceding(string, string.length() - 1, '\\') % 2 == 0;
    }

    public ExtendedProperties() {
        try {
            this.fileSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(this){
                private final ExtendedProperties this$0;
                {
                    this.this$0 = extendedProperties;
                }

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        catch (SecurityException securityException) {
            this.fileSeparator = File.separator;
        }
        this.isInitialized = false;
        this.keysAsListed = new ArrayList();
    }

    public ExtendedProperties(String file) throws IOException {
        this(file, null);
    }

    public ExtendedProperties(String file, String defaultFile) throws IOException {
        try {
            this.fileSeparator = (String)AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        catch (SecurityException securityException) {
            this.fileSeparator = File.separator;
        }
        this.isInitialized = false;
        this.keysAsListed = new ArrayList();
        this.file = file;
        this.basePath = new File(file).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.load(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        if (defaultFile != null) {
            this.defaults = new ExtendedProperties(defaultFile);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String inc) {
        include = inc;
    }

    public void load(InputStream input) throws IOException {
        this.load(input, null);
    }

    public synchronized void load(InputStream input, String enc) throws IOException {
        PropertiesReader propertiesReader = null;
        if (enc != null) {
            try {
                propertiesReader = new PropertiesReader(new InputStreamReader(input, enc));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (propertiesReader == null) {
            try {
                propertiesReader = new PropertiesReader(new InputStreamReader(input, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                propertiesReader = new PropertiesReader(new InputStreamReader(input));
            }
        }
        try {
            while (true) {
                String string;
                if ((string = propertiesReader.readProperty()) == null) {
                    return;
                }
                int n2 = string.indexOf(61);
                if (n2 <= 0) continue;
                String string2 = string.substring(0, n2).trim();
                String string3 = string.substring(n2 + 1).trim();
                if ("".equals(string3)) continue;
                if (this.getInclude() != null && string2.equalsIgnoreCase(this.getInclude())) {
                    File file;
                    if (string3.startsWith(this.fileSeparator)) {
                        file = new File(string3);
                    } else {
                        if (string3.startsWith("." + this.fileSeparator)) {
                            string3 = string3.substring(2);
                        }
                        file = new File(this.basePath + string3);
                    }
                    if (!file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(string2, string3);
            }
        }
        finally {
            this.isInitialized = true;
        }
    }

    public Object getProperty(String key) {
        Object v2 = this.get(key);
        if (v2 == null && this.defaults != null) {
            v2 = this.defaults.get(key);
        }
        return v2;
    }

    public void addProperty(String key, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.indexOf(",") > 0) {
                PropertiesTokenizer propertiesTokenizer = new PropertiesTokenizer(string);
                while (propertiesTokenizer.hasMoreTokens()) {
                    String string2 = propertiesTokenizer.nextToken();
                    this.addPropertyInternal(key, ExtendedProperties.unescape(string2));
                }
            } else {
                this.addPropertyInternal(key, ExtendedProperties.unescape(string));
            }
        } else {
            this.addPropertyInternal(key, value);
        }
        this.isInitialized = true;
    }

    private void addPropertyDirect(String key, Object value) {
        if (!this.containsKey(key)) {
            this.keysAsListed.add(key);
        }
        this.put(key, value);
    }

    private void addPropertyInternal(String key, Object value) {
        Object v2 = this.get(key);
        if (v2 instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.add(v2);
            vector.add(value);
            this.put(key, vector);
            return;
        }
        if (v2 instanceof List) {
            ((List)v2).add(value);
            return;
        }
        if (!this.containsKey(key)) {
            this.keysAsListed.add(key);
        }
        this.put(key, value);
    }

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public synchronized void save(OutputStream output, String header) throws IOException {
        if (output == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(output);
        if (header != null) {
            printWriter.println(header);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v2 = this.get(string);
            if (v2 != null) {
                Object object;
                if (v2 instanceof String) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(string);
                    ((StringBuffer)object).append("=");
                    ((StringBuffer)object).append(ExtendedProperties.escape((String)v2));
                    printWriter.println(((StringBuffer)object).toString());
                } else if (v2 instanceof List) {
                    object = (List)v2;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string);
                        stringBuffer.append("=");
                        stringBuffer.append(ExtendedProperties.escape(string2));
                        printWriter.println(stringBuffer.toString());
                    }
                }
            }
            printWriter.println();
            printWriter.flush();
        }
    }

    public void combine(ExtendedProperties props) {
        Iterator iterator = props.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setProperty(string, props.get(string));
        }
    }

    public void clearProperty(String key) {
        if (this.containsKey(key)) {
            for (int i2 = 0; i2 < this.keysAsListed.size(); ++i2) {
                if (!this.keysAsListed.get(i2).equals(key)) continue;
                this.keysAsListed.remove(i2);
                break;
            }
            this.remove(key);
        }
    }

    public Iterator getKeys() {
        return this.keysAsListed.iterator();
    }

    public Iterator getKeys(String prefix) {
        Iterator iterator = this.getKeys();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String) || !((String)e2).startsWith(prefix)) continue;
            arrayList.add(e2);
        }
        return arrayList.iterator();
    }

    public ExtendedProperties subset(String prefix) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Iterator iterator = this.getKeys();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof String) || !((String)e2).startsWith(prefix)) continue;
            if (!bl) {
                bl = true;
            }
            String string = ((String)e2).length() == prefix.length() ? prefix : ((String)e2).substring(prefix.length() + 1);
            extendedProperties.addPropertyDirect(string, this.get(e2));
        }
        if (bl) {
            return extendedProperties;
        }
        return null;
    }

    public void display() {
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v2 = this.get(string);
            System.out.println(string + " => " + v2);
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof String) {
            return this.interpolate((String)v2);
        }
        if (v2 == null) {
            if (this.defaults != null) {
                ExtendedProperties extendedProperties = this;
                return extendedProperties.interpolate(extendedProperties.defaults.getString(key, defaultValue));
            }
            return this.interpolate(defaultValue);
        }
        if (v2 instanceof List) {
            return this.interpolate((String)((List)v2).get(0));
        }
        throw new ClassCastException("'" + key + "' doesn't map to a String object");
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, new Properties());
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] stringArray = this.getStringArray(key);
        Properties properties = new Properties(defaults);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n2 = string.indexOf(61);
            if (n2 <= 0) {
                throw new IllegalArgumentException("'" + string + "' does not contain an equals sign");
            }
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1).trim();
            properties.put(string2, string3);
        }
        return properties;
    }

    public String[] getStringArray(String key) {
        List list;
        Object v2 = this.get(key);
        if (v2 instanceof String) {
            list = new Vector(1);
            list.add(v2);
        } else if (v2 instanceof List) {
            list = (List)v2;
        } else {
            if (v2 == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(key);
                }
                return new String[0];
            }
            throw new ClassCastException("'" + key + "' doesn't map to a String/List object");
        }
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)list.get(i2);
        }
        return stringArray;
    }

    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    public Vector getVector(String key, Vector defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof List) {
            return new Vector((List)v2);
        }
        if (v2 instanceof String) {
            Vector vector = new Vector(1);
            vector.add(v2);
            this.put(key, vector);
            return vector;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(key, defaultValue);
            }
            if (defaultValue == null) {
                return new Vector();
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Vector object");
    }

    public List getList(String key) {
        return this.getList(key, null);
    }

    public List getList(String key, List defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof List) {
            return new ArrayList((List)v2);
        }
        if (v2 instanceof String) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(v2);
            this.put(key, arrayList);
            return arrayList;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getList(key, defaultValue);
            }
            if (defaultValue == null) {
                return new ArrayList();
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a List object");
    }

    public boolean getBoolean(String key) {
        Boolean bl = this.getBoolean(key, null);
        if (bl != null) {
            return bl;
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, (Boolean)defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Boolean) {
            return (Boolean)v2;
        }
        if (v2 instanceof String) {
            String string = this.testBoolean((String)v2);
            Boolean bl = new Boolean(string);
            this.put(key, bl);
            return bl;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Boolean object");
    }

    public String testBoolean(String value) {
        String string = value.toLowerCase();
        if (string.equals("true") || string.equals("on") || string.equals("yes")) {
            return "true";
        }
        if (string.equals("false") || string.equals("off") || string.equals("no")) {
            return "false";
        }
        return null;
    }

    public byte getByte(String key) {
        Byte by = this.getByte(key, null);
        if (by != null) {
            return by;
        }
        throw new NoSuchElementException("'" + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, (Byte)defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Byte) {
            return (Byte)v2;
        }
        if (v2 instanceof String) {
            Byte by = new Byte((String)v2);
            this.put(key, by);
            return by;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Byte object");
    }

    public short getShort(String key) {
        Short s2 = this.getShort(key, null);
        if (s2 != null) {
            return s2;
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, (Short)defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Short) {
            return (Short)v2;
        }
        if (v2 instanceof String) {
            Short s2 = new Short((String)v2);
            this.put(key, s2);
            return s2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Short object");
    }

    public int getInt(String name) {
        return this.getInteger(name);
    }

    public int getInt(String name, int def) {
        return this.getInteger(name, def);
    }

    public int getInteger(String key) {
        Integer n2 = this.getInteger(key, null);
        if (n2 != null) {
            return n2;
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public int getInteger(String key, int defaultValue) {
        Integer n2 = this.getInteger(key, null);
        if (n2 == null) {
            return defaultValue;
        }
        return n2;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Integer) {
            return (Integer)v2;
        }
        if (v2 instanceof String) {
            Integer n2 = new Integer((String)v2);
            this.put(key, n2);
            return n2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Integer object");
    }

    public long getLong(String key) {
        Long l2 = this.getLong(key, null);
        if (l2 != null) {
            return l2;
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Long) {
            return (Long)v2;
        }
        if (v2 instanceof String) {
            Long l2 = new Long((String)v2);
            this.put(key, l2);
            return l2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Long object");
    }

    public float getFloat(String key) {
        Float f2 = this.getFloat(key, null);
        if (f2 != null) {
            return f2.floatValue();
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, Float.valueOf(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Float) {
            return (Float)v2;
        }
        if (v2 instanceof String) {
            Float f2 = new Float((String)v2);
            this.put(key, f2);
            return f2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Float object");
    }

    public double getDouble(String key) {
        Double d2 = this.getDouble(key, null);
        if (d2 != null) {
            return d2;
        }
        throw new NoSuchElementException("'" + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, (Double)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        Object v2 = this.get(key);
        if (v2 instanceof Double) {
            return (Double)v2;
        }
        if (v2 instanceof String) {
            Double d2 = new Double((String)v2);
            this.put(key, d2);
            return d2;
        }
        if (v2 == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException("'" + key + "' doesn't map to a Double object");
    }

    public static ExtendedProperties convertProperties(Properties props) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            extendedProperties.setProperty(string, props.getProperty(string));
        }
        return extendedProperties;
    }

    static boolean access$000(String x0) {
        return ExtendedProperties.endsWithSlash(x0);
    }

    static class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String string = super.nextToken();
                if (ExtendedProperties.access$000(string)) {
                    stringBuffer.append(string.substring(0, string.length() - 1));
                    stringBuffer.append(DELIMITER);
                    continue;
                }
                stringBuffer.append(string);
                break;
            }
            return stringBuffer.toString().trim();
        }
    }

    static class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.readLine();
            while (string != null) {
                if ((string = string.trim()).length() != 0 && string.charAt(0) != '#') {
                    if (ExtendedProperties.access$000(string)) {
                        string = string.substring(0, string.length() - 1);
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(string);
                        return stringBuffer.toString();
                    }
                }
                string = this.readLine();
            }
            return null;
        }
    }
}

