/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;

public class BoundedBuffer
extends SynchronizedBuffer
implements BoundedCollection {
    private static final long serialVersionUID = 1536432911093974264L;
    private final int maximumSize;
    private final long timeout;

    public static BoundedBuffer decorate(Buffer buffer, int maximumSize) {
        return new BoundedBuffer(buffer, maximumSize, 0L);
    }

    public static BoundedBuffer decorate(Buffer buffer, int maximumSize, long timeout) {
        return new BoundedBuffer(buffer, maximumSize, timeout);
    }

    protected BoundedBuffer(Buffer buffer, int maximumSize, long timeout) {
        super(buffer);
        if (maximumSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumSize = maximumSize;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.getBuffer().remove();
            this.lock.notifyAll();
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o2) {
        Object object = this.lock;
        synchronized (object) {
            this.timeoutWait(1);
            return this.getBuffer().add(o2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c2) {
        Object object = this.lock;
        synchronized (object) {
            this.timeoutWait(c2.size());
            return this.getBuffer().addAll(c2);
        }
    }

    public Iterator iterator() {
        BoundedBuffer boundedBuffer = this;
        return new NotifyingIterator(boundedBuffer, boundedBuffer.collection.iterator());
    }

    private void timeoutWait(int nAdditions) {
        if (nAdditions > this.maximumSize) {
            throw new BufferOverflowException("Buffer size cannot exceed " + this.maximumSize);
        }
        if (this.timeout <= 0L) {
            if (this.getBuffer().size() + nAdditions > this.maximumSize) {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.maximumSize);
            }
            return;
        }
        long l2 = System.currentTimeMillis() + this.timeout;
        long l3 = l2 - System.currentTimeMillis();
        while (l3 > 0L && this.getBuffer().size() + nAdditions > this.maximumSize) {
            try {
                this.lock.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
            catch (InterruptedException interruptedException) {
                PrintWriter printWriter = new PrintWriter(new StringWriter());
                interruptedException.printStackTrace(printWriter);
                throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
            }
        }
        if (this.getBuffer().size() + nAdditions > this.maximumSize) {
            throw new BufferOverflowException("Timeout expired");
        }
    }

    public boolean isFull() {
        return this.size() == this.maxSize();
    }

    public int maxSize() {
        return this.maximumSize;
    }

    static Object access$000(BoundedBuffer x0) {
        return x0.lock;
    }

    static Object access$100(BoundedBuffer x0) {
        return x0.lock;
    }

    private class NotifyingIterator
    extends AbstractIteratorDecorator {
        private final BoundedBuffer this$0;

        public NotifyingIterator(BoundedBuffer boundedBuffer, Iterator it) {
            super(it);
            this.this$0 = boundedBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Object object = BoundedBuffer.access$000(this.this$0);
            synchronized (object) {
                this.iterator.remove();
                BoundedBuffer.access$100(this.this$0).notifyAll();
                return;
            }
        }
    }
}

