/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.CharRange;

public class CharSet
implements Serializable {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final CharSet EMPTY = new CharSet(new String[]{null});
    public static final CharSet ASCII_ALPHA = new CharSet("a-zA-Z");
    public static final CharSet ASCII_ALPHA_LOWER = new CharSet("a-z");
    public static final CharSet ASCII_ALPHA_UPPER = new CharSet("A-Z");
    public static final CharSet ASCII_NUMERIC = new CharSet("0-9");
    protected static final Map<String, CharSet> COMMON = Collections.synchronizedMap(new HashMap());
    private final Set<CharRange> set = Collections.synchronizedSet(new HashSet());

    public static CharSet getInstance(String ... setStrs) {
        CharSet charSet;
        if (setStrs == null) {
            return null;
        }
        if (setStrs.length == 1 && (charSet = COMMON.get(setStrs[0])) != null) {
            return charSet;
        }
        return new CharSet(setStrs);
    }

    protected CharSet(String ... set) {
        String[] stringArray = set;
        int n2 = set.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            this.add(string);
        }
    }

    protected void add(String str) {
        if (str == null) {
            return;
        }
        int n2 = str.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - n3;
            if (n4 >= 4 && str.charAt(n3) == '^' && str.charAt(n3 + 2) == '-') {
                this.set.add(CharRange.isNotIn(str.charAt(n3 + 1), str.charAt(n3 + 3)));
                n3 += 4;
                continue;
            }
            if (n4 >= 3 && str.charAt(n3 + 1) == '-') {
                this.set.add(CharRange.isIn(str.charAt(n3), str.charAt(n3 + 2)));
                n3 += 3;
                continue;
            }
            if (n4 >= 2 && str.charAt(n3) == '^') {
                this.set.add(CharRange.isNot(str.charAt(n3 + 1)));
                n3 += 2;
                continue;
            }
            this.set.add(CharRange.is(str.charAt(n3)));
            ++n3;
        }
    }

    CharRange[] getCharRanges() {
        return this.set.toArray(new CharRange[this.set.size()]);
    }

    public boolean contains(char ch) {
        for (CharRange charRange : this.set) {
            if (!charRange.contains(ch)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet charSet = (CharSet)obj;
        return this.set.equals(charSet.set);
    }

    public int hashCode() {
        return 89 + this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }

    static {
        COMMON.put(null, EMPTY);
        COMMON.put("", EMPTY);
        COMMON.put("a-zA-Z", ASCII_ALPHA);
        COMMON.put("A-Za-z", ASCII_ALPHA);
        COMMON.put("a-z", ASCII_ALPHA_LOWER);
        COMMON.put("A-Z", ASCII_ALPHA_UPPER);
        COMMON.put("0-9", ASCII_NUMERIC);
    }
}

