/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class LocaleUtils {
    private static final ConcurrentMap<String, List<Locale>> cLanguagesByCountry = new ConcurrentHashMap<String, List<Locale>>();
    private static final ConcurrentMap<String, List<Locale>> cCountriesByLanguage = new ConcurrentHashMap<String, List<Locale>>();

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new Locale("", "");
        }
        if (str.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        int n2 = str.length();
        if (n2 < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char c2 = str.charAt(0);
        if (c2 == '_') {
            if (n2 < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            char c3 = str.charAt(1);
            char c4 = str.charAt(2);
            if (!Character.isUpperCase(c3) || !Character.isUpperCase(c4)) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (n2 == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (n2 < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (str.charAt(3) != '_') {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        return LocaleUtils.parseLocale(str);
    }

    private static Locale parseLocale(String str) {
        if (LocaleUtils.isISO639LanguageCode(str)) {
            return new Locale(str);
        }
        String[] stringArray = str.split("_", -1);
        String string = stringArray[0];
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            if (LocaleUtils.isISO639LanguageCode(string) && LocaleUtils.isISO3166CountryCode(string2) || LocaleUtils.isNumericAreaCode(string2)) {
                return new Locale(string, string2);
            }
        } else if (stringArray.length == 3) {
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            if (LocaleUtils.isISO639LanguageCode(string) && (string3.length() == 0 || LocaleUtils.isISO3166CountryCode(string3) || LocaleUtils.isNumericAreaCode(string3)) && string4.length() > 0) {
                return new Locale(string, string3, string4);
            }
        }
        throw new IllegalArgumentException("Invalid locale format: " + str);
    }

    private static boolean isISO639LanguageCode(String str) {
        return StringUtils.isAllLowerCase(str) && (str.length() == 2 || str.length() == 3);
    }

    private static boolean isISO3166CountryCode(String str) {
        return StringUtils.isAllUpperCase(str) && str.length() == 2;
    }

    private static boolean isNumericAreaCode(String str) {
        return StringUtils.isNumeric(str) && str.length() == 3;
    }

    public static List<Locale> localeLookupList(Locale locale) {
        Locale locale2 = locale;
        return LocaleUtils.localeLookupList(locale2, locale2);
    }

    public static List<Locale> localeLookupList(Locale locale, Locale defaultLocale) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (locale != null) {
            arrayList.add(locale);
            if (locale.getVariant().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                arrayList.add(new Locale(locale.getLanguage(), ""));
            }
            if (!arrayList.contains(defaultLocale)) {
                arrayList.add(defaultLocale);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_LIST;
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_SET;
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LocaleUtils.availableLocaleList().contains(locale);
    }

    public static List<Locale> languagesByCountry(String countryCode) {
        if (countryCode == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)cLanguagesByCountry.get(countryCode);
        if (list == null) {
            list = new ArrayList();
            List<Locale> list2 = LocaleUtils.availableLocaleList();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Locale locale = list2.get(i2);
                if (!countryCode.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            cLanguagesByCountry.putIfAbsent(countryCode, list);
            list = (List)cLanguagesByCountry.get(countryCode);
        }
        return list;
    }

    public static List<Locale> countriesByLanguage(String languageCode) {
        if (languageCode == null) {
            return Collections.emptyList();
        }
        List<Locale> list = (ArrayList)cCountriesByLanguage.get(languageCode);
        if (list == null) {
            list = new ArrayList();
            List<Locale> list2 = LocaleUtils.availableLocaleList();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Locale locale = list2.get(i2);
                if (!languageCode.equals(locale.getLanguage()) || locale.getCountry().length() == 0 || !locale.getVariant().isEmpty()) continue;
                list.add(locale);
            }
            list = Collections.unmodifiableList(list);
            cCountriesByLanguage.putIfAbsent(languageCode, list);
            list = (List)cCountriesByLanguage.get(languageCode);
        }
        return list;
    }

    static class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_LIST;
        private static final Set<Locale> AVAILABLE_LOCALE_SET;

        SyncAvoid() {
        }

        static {
            ArrayList<Locale> arrayList = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
            AVAILABLE_LOCALE_LIST = Collections.unmodifiableList(arrayList);
            AVAILABLE_LOCALE_SET = Collections.unmodifiableSet(new HashSet<Locale>(arrayList));
        }
    }
}

