/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateParser;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameInstant(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date1.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.getTime().getTime() == cal2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(14) == cal2.get(14) && cal1.get(13) == cal2.get(13) && cal1.get(12) == cal2.get(12) && cal1.get(11) == cal2.get(11) && cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0) && cal1.getClass() == cal2.getClass();
    }

    public static Date parseDate(String str, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDate(str, null, parsePatterns);
    }

    public static Date parseDate(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, locale, parsePatterns, true);
    }

    public static Date parseDateStrictly(String str, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateStrictly(str, null, parsePatterns);
    }

    public static Date parseDateStrictly(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, locale, parsePatterns, false);
    }

    private static Date parseDateWithLeniency(String str, Locale locale, String[] parsePatterns, boolean lenient) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale2 = locale == null ? Locale.getDefault() : locale;
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(timeZone, locale2);
        calendar.setLenient(lenient);
        String[] stringArray = parsePatterns;
        int n2 = parsePatterns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            FastDateParser fastDateParser = new FastDateParser(string, timeZone, locale2);
            calendar.clear();
            try {
                if (fastDateParser.parse(str, parsePosition, calendar) && parsePosition.getIndex() == str.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            parsePosition.setIndex(0);
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtils.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarField, amount);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return DateUtils.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return DateUtils.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return DateUtils.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return DateUtils.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return DateUtils.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return DateUtils.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return DateUtils.set(date, 14, amount);
    }

    private static Date set(Date date, int calendarField, int amount) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(calendarField, amount);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        Calendar calendar = Calendar.getInstance(tz);
        calendar.setTime(date);
        return calendar;
    }

    public static Date round(Date date, int field) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, field, ModifyType.ROUND);
        return calendar.getTime();
    }

    public static Calendar round(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = (Calendar)date.clone();
        DateUtils.modify(calendar, field, ModifyType.ROUND);
        return calendar;
    }

    public static Date round(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtils.round((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtils.round((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not round " + date);
    }

    public static Date truncate(Date date, int field) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, field, ModifyType.TRUNCATE);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = (Calendar)date.clone();
        DateUtils.modify(calendar, field, ModifyType.TRUNCATE);
        return calendar;
    }

    public static Date truncate(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtils.truncate((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtils.truncate((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not truncate " + date);
    }

    public static Date ceiling(Date date, int field) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, field, ModifyType.CEILING);
        return calendar.getTime();
    }

    public static Calendar ceiling(Calendar date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = (Calendar)date.clone();
        DateUtils.modify(calendar, field, ModifyType.CEILING);
        return calendar;
    }

    public static Date ceiling(Object date, int field) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date instanceof Date) {
            return DateUtils.ceiling((Date)date, field);
        }
        if (date instanceof Calendar) {
            return DateUtils.ceiling((Calendar)date, field).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + date.getClass());
    }

    private static void modify(Calendar val, int field, ModifyType modType) {
        if (val.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (field == 14) {
            return;
        }
        Date date = val.getTime();
        long l2 = date.getTime();
        boolean bl = false;
        int n2 = val.get(14);
        if (ModifyType.TRUNCATE == modType || n2 < 500) {
            l2 -= (long)n2;
        }
        if (field == 13) {
            bl = true;
        }
        int n3 = val.get(13);
        if (!(bl || ModifyType.TRUNCATE != modType && n3 >= 30)) {
            l2 -= (long)n3 * 1000L;
        }
        if (field == 12) {
            bl = true;
        }
        int n4 = val.get(12);
        if (!(bl || ModifyType.TRUNCATE != modType && n4 >= 30)) {
            l2 -= (long)n4 * 60000L;
        }
        if (date.getTime() != l2) {
            date.setTime(l2);
            val.setTime(date);
        }
        boolean bl2 = false;
        int[][] nArray = fields;
        int n5 = fields.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6;
            int n7;
            int[] nArray2;
            int[] nArray3 = nArray2 = nArray[i2];
            int n8 = nArray2.length;
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = nArray3[n7];
                if (n6 != field) continue;
                if (modType == ModifyType.CEILING || modType == ModifyType.ROUND && bl2) {
                    if (field == 1001) {
                        if (val.get(5) == 1) {
                            val.add(5, 15);
                            return;
                        }
                        val.add(5, -15);
                        val.add(2, 1);
                        return;
                    }
                    if (field == 9) {
                        if (val.get(11) == 0) {
                            val.add(11, 12);
                            return;
                        }
                        val.add(11, -12);
                        val.add(5, 1);
                        return;
                    }
                    val.add(nArray2[0], 1);
                }
                return;
            }
            int n9 = 0;
            n8 = 0;
            switch (field) {
                case 1001: {
                    if (nArray2[0] != 5) break;
                    n9 = val.get(5) - 1;
                    if (n9 >= 15) {
                        n9 -= 15;
                    }
                    bl2 = n9 > 7;
                    n8 = 1;
                    break;
                }
                case 9: {
                    if (nArray2[0] != 11) break;
                    n9 = val.get(11);
                    if (n9 >= 12) {
                        n9 -= 12;
                    }
                    bl2 = n9 >= 6;
                    n8 = 1;
                }
            }
            if (n8 == 0) {
                n7 = val.getActualMinimum(nArray2[0]);
                n6 = val.getActualMaximum(nArray2[0]);
                n9 = val.get(nArray2[0]) - n7;
                boolean bl3 = bl2 = n9 > (n6 - n7) / 2;
            }
            if (n9 == 0) continue;
            val.set(nArray2[0], val.get(nArray2[0]) - n9);
        }
        throw new IllegalArgumentException("The field " + field + " is not supported");
    }

    public static Iterator<Calendar> iterator(Date focus, int rangeStyle) {
        DateUtils.validateDateNotNull(focus);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(focus);
        return DateUtils.iterator(calendar, rangeStyle);
    }

    public static Iterator<Calendar> iterator(Calendar focus, int rangeStyle) {
        Calendar calendar;
        Calendar calendar2;
        if (focus == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        int n2 = 1;
        int n3 = 7;
        block0 : switch (rangeStyle) {
            case 5: 
            case 6: {
                calendar2 = DateUtils.truncate(focus, 2);
                calendar = (Calendar)calendar2.clone();
                calendar.add(2, 1);
                calendar.add(5, -1);
                if (rangeStyle != 6) break;
                n2 = 2;
                n3 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar2 = DateUtils.truncate(focus, 5);
                calendar = DateUtils.truncate(focus, 5);
                switch (rangeStyle) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        n2 = 2;
                        n3 = 1;
                        break block0;
                    }
                    case 3: {
                        n2 = focus.get(7);
                        n3 = n2 - 1;
                        break block0;
                    }
                    case 4: {
                        n2 = focus.get(7) - 3;
                        n3 = focus.get(7) + 3;
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + rangeStyle + " is not valid.");
            }
        }
        if (n2 <= 0) {
            n2 += 7;
        }
        if (n2 > 7) {
            n2 -= 7;
        }
        if (n3 <= 0) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        while (calendar2.get(7) != n2) {
            calendar2.add(5, -1);
        }
        while (calendar.get(7) != n3) {
            calendar.add(5, 1);
        }
        return new DateIterator(calendar2, calendar);
    }

    public static Iterator<?> iterator(Object focus, int rangeStyle) {
        if (focus == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (focus instanceof Date) {
            return DateUtils.iterator((Date)focus, rangeStyle);
        }
        if (focus instanceof Calendar) {
            return DateUtils.iterator((Calendar)focus, rangeStyle);
        }
        throw new ClassCastException("Could not iterate based on " + focus);
    }

    public static long getFragmentInMilliseconds(Date date, int fragment) {
        return DateUtils.getFragment(date, fragment, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInSeconds(Date date, int fragment) {
        return DateUtils.getFragment(date, fragment, TimeUnit.SECONDS);
    }

    public static long getFragmentInMinutes(Date date, int fragment) {
        return DateUtils.getFragment(date, fragment, TimeUnit.MINUTES);
    }

    public static long getFragmentInHours(Date date, int fragment) {
        return DateUtils.getFragment(date, fragment, TimeUnit.HOURS);
    }

    public static long getFragmentInDays(Date date, int fragment) {
        return DateUtils.getFragment(date, fragment, TimeUnit.DAYS);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int fragment) {
        return DateUtils.getFragment(calendar, fragment, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInSeconds(Calendar calendar, int fragment) {
        return DateUtils.getFragment(calendar, fragment, TimeUnit.SECONDS);
    }

    public static long getFragmentInMinutes(Calendar calendar, int fragment) {
        return DateUtils.getFragment(calendar, fragment, TimeUnit.MINUTES);
    }

    public static long getFragmentInHours(Calendar calendar, int fragment) {
        return DateUtils.getFragment(calendar, fragment, TimeUnit.HOURS);
    }

    public static long getFragmentInDays(Calendar calendar, int fragment) {
        return DateUtils.getFragment(calendar, fragment, TimeUnit.DAYS);
    }

    private static long getFragment(Date date, int fragment, TimeUnit unit) {
        DateUtils.validateDateNotNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFragment(calendar, fragment, unit);
    }

    private static long getFragment(Calendar calendar, int fragment, TimeUnit unit) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long l2 = 0L;
        int n2 = unit == TimeUnit.DAYS ? 0 : 1;
        switch (fragment) {
            case 1: {
                l2 = 0L + unit.convert(calendar.get(6) - n2, TimeUnit.DAYS);
                break;
            }
            case 2: {
                l2 = 0L + unit.convert(calendar.get(5) - n2, TimeUnit.DAYS);
            }
        }
        switch (fragment) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l2 += unit.convert(calendar.get(11), TimeUnit.HOURS);
            }
            case 11: {
                l2 += unit.convert(calendar.get(12), TimeUnit.MINUTES);
            }
            case 12: {
                l2 += unit.convert(calendar.get(13), TimeUnit.SECONDS);
            }
            case 13: {
                l2 += unit.convert(calendar.get(14), TimeUnit.MILLISECONDS);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + fragment + " is not supported");
            }
        }
        return l2;
    }

    public static boolean truncatedEquals(Calendar cal1, Calendar cal2, int field) {
        return DateUtils.truncatedCompareTo(cal1, cal2, field) == 0;
    }

    public static boolean truncatedEquals(Date date1, Date date2, int field) {
        return DateUtils.truncatedCompareTo(date1, date2, field) == 0;
    }

    public static int truncatedCompareTo(Calendar cal1, Calendar cal2, int field) {
        Calendar calendar = DateUtils.truncate(cal1, field);
        Calendar calendar2 = DateUtils.truncate(cal2, field);
        return calendar.compareTo(calendar2);
    }

    public static int truncatedCompareTo(Date date1, Date date2, int field) {
        Date date = DateUtils.truncate(date1, field);
        Date date3 = DateUtils.truncate(date2, field);
        return date.compareTo(date3);
    }

    private static void validateDateNotNull(Date date) {
        Validate.isTrue(date != null, "The date must not be null", new Object[0]);
    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar startFinal, Calendar endFinal) {
            this.endFinal = endFinal;
            this.spot = startFinal;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        @Override
        public Calendar next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return (Calendar)this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }
}

