/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Formattable;
import java.util.Formatter;

public class FormattableUtils {
    private static final String SIMPLEST_FORMAT = "%s";

    public static String toString(Formattable formattable) {
        return String.format(SIMPLEST_FORMAT, formattable);
    }

    public static Formatter append(CharSequence seq, Formatter formatter, int flags, int width, int precision) {
        return FormattableUtils.append(seq, formatter, flags, width, precision, ' ', null);
    }

    public static Formatter append(CharSequence seq, Formatter formatter, int flags, int width, int precision, char padChar) {
        return FormattableUtils.append(seq, formatter, flags, width, precision, padChar, null);
    }

    public static Formatter append(CharSequence seq, Formatter formatter, int flags, int width, int precision, CharSequence ellipsis) {
        return FormattableUtils.append(seq, formatter, flags, width, precision, ' ', ellipsis);
    }

    public static Formatter append(CharSequence seq, Formatter formatter, int flags, int width, int precision, char padChar, CharSequence ellipsis) {
        if (ellipsis != null && precision >= 0 && ellipsis.length() > precision) {
            throw new IllegalArgumentException(String.format("Specified ellipsis '%1$s' exceeds precision of %2$s", ellipsis, precision));
        }
        StringBuilder stringBuilder = new StringBuilder(seq);
        if (precision >= 0 && precision < seq.length()) {
            CharSequence charSequence = ellipsis == null ? "" : ellipsis;
            stringBuilder.replace(precision - charSequence.length(), seq.length(), charSequence.toString());
        }
        boolean bl = (flags & 1) == 1;
        for (int i2 = stringBuilder.length(); i2 < width; ++i2) {
            stringBuilder.insert(bl ? i2 : 0, padChar);
        }
        formatter.format(stringBuilder.toString(), new Object[0]);
        return formatter;
    }
}

