/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.CsvTranslators;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.commons.text.translate.NumericEntityEscaper;
import org.apache.commons.text.translate.NumericEntityUnescaper;
import org.apache.commons.text.translate.OctalUnescaper;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.apache.commons.text.translate.UnicodeUnpairedSurrogateRemover;

public class StringEscapeUtils {
    public static final CharSequenceTranslator ESCAPE_JAVA;
    public static final CharSequenceTranslator ESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator ESCAPE_JSON;
    public static final CharSequenceTranslator ESCAPE_XML10;
    public static final CharSequenceTranslator ESCAPE_XML11;
    public static final CharSequenceTranslator ESCAPE_HTML3;
    public static final CharSequenceTranslator ESCAPE_HTML4;
    public static final CharSequenceTranslator ESCAPE_CSV;
    public static final CharSequenceTranslator ESCAPE_XSI;
    public static final CharSequenceTranslator UNESCAPE_JAVA;
    public static final CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator UNESCAPE_JSON;
    public static final CharSequenceTranslator UNESCAPE_HTML3;
    public static final CharSequenceTranslator UNESCAPE_HTML4;
    public static final CharSequenceTranslator UNESCAPE_XML;
    public static final CharSequenceTranslator UNESCAPE_CSV;
    public static final CharSequenceTranslator UNESCAPE_XSI;

    public static Builder builder(CharSequenceTranslator translator) {
        return new Builder(translator);
    }

    public static final String escapeJava(String input) {
        return ESCAPE_JAVA.translate(input);
    }

    public static final String escapeEcmaScript(String input) {
        return ESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String escapeJson(String input) {
        return ESCAPE_JSON.translate(input);
    }

    public static final String unescapeJava(String input) {
        return UNESCAPE_JAVA.translate(input);
    }

    public static final String unescapeEcmaScript(String input) {
        return UNESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String unescapeJson(String input) {
        return UNESCAPE_JSON.translate(input);
    }

    public static final String escapeHtml4(String input) {
        return ESCAPE_HTML4.translate(input);
    }

    public static final String escapeHtml3(String input) {
        return ESCAPE_HTML3.translate(input);
    }

    public static final String unescapeHtml4(String input) {
        return UNESCAPE_HTML4.translate(input);
    }

    public static final String unescapeHtml3(String input) {
        return UNESCAPE_HTML3.translate(input);
    }

    public static String escapeXml10(String input) {
        return ESCAPE_XML10.translate(input);
    }

    public static String escapeXml11(String input) {
        return ESCAPE_XML11.translate(input);
    }

    public static final String unescapeXml(String input) {
        return UNESCAPE_XML.translate(input);
    }

    public static final String escapeCsv(String input) {
        return ESCAPE_CSV.translate(input);
    }

    public static final String unescapeCsv(String input) {
        return UNESCAPE_CSV.translate(input);
    }

    public static final String escapeXSI(String input) {
        return ESCAPE_XSI.translate(input);
    }

    public static final String unescapeXSI(String input) {
        return UNESCAPE_XSI.translate(input);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("\"", "\\\"");
        hashMap.put("\\", "\\\\");
        ESCAPE_JAVA = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(hashMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        hashMap = new HashMap<String, String>();
        hashMap.put("'", "\\'");
        hashMap.put("\"", "\\\"");
        hashMap.put("\\", "\\\\");
        hashMap.put("/", "\\/");
        ESCAPE_ECMASCRIPT = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(hashMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        hashMap = new HashMap<String, String>();
        hashMap.put("\"", "\\\"");
        hashMap.put("\\", "\\\\");
        hashMap.put("/", "\\/");
        ESCAPE_JSON = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(hashMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        hashMap = new HashMap<String, String>();
        hashMap.put("\u0000", "");
        hashMap.put("\u0001", "");
        hashMap.put("\u0002", "");
        hashMap.put("\u0003", "");
        hashMap.put("\u0004", "");
        hashMap.put("\u0005", "");
        hashMap.put("\u0006", "");
        hashMap.put("\u0007", "");
        hashMap.put("\b", "");
        hashMap.put("\u000b", "");
        hashMap.put("\f", "");
        hashMap.put("\u000e", "");
        hashMap.put("\u000f", "");
        hashMap.put("\u0010", "");
        hashMap.put("\u0011", "");
        hashMap.put("\u0012", "");
        hashMap.put("\u0013", "");
        hashMap.put("\u0014", "");
        hashMap.put("\u0015", "");
        hashMap.put("\u0016", "");
        hashMap.put("\u0017", "");
        hashMap.put("\u0018", "");
        hashMap.put("\u0019", "");
        hashMap.put("\u001a", "");
        hashMap.put("\u001b", "");
        hashMap.put("\u001c", "");
        hashMap.put("\u001d", "");
        hashMap.put("\u001e", "");
        hashMap.put("\u001f", "");
        hashMap.put("\ufffe", "");
        hashMap.put("\uffff", "");
        ESCAPE_XML10 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(hashMap)), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
        hashMap = new HashMap<String, String>();
        hashMap.put("\u0000", "");
        hashMap.put("\u000b", "&#11;");
        hashMap.put("\f", "&#12;");
        hashMap.put("\ufffe", "");
        hashMap.put("\uffff", "");
        ESCAPE_XML11 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(hashMap)), NumericEntityEscaper.between(1, 8), NumericEntityEscaper.between(14, 31), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
        ESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE));
        ESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE));
        ESCAPE_CSV = new CsvTranslators.CsvEscaper();
        hashMap = new HashMap<String, String>();
        hashMap.put("|", "\\|");
        hashMap.put("&", "\\&");
        hashMap.put(";", "\\;");
        hashMap.put("<", "\\<");
        hashMap.put(">", "\\>");
        hashMap.put("(", "\\(");
        hashMap.put(")", "\\)");
        hashMap.put("$", "\\$");
        hashMap.put("`", "\\`");
        hashMap.put("\\", "\\\\");
        hashMap.put("\"", "\\\"");
        hashMap.put("'", "\\'");
        hashMap.put(" ", "\\ ");
        hashMap.put("\t", "\\\t");
        hashMap.put("\r\n", "");
        hashMap.put("\n", "");
        hashMap.put("*", "\\*");
        hashMap.put("?", "\\?");
        hashMap.put("[", "\\[");
        hashMap.put("#", "\\#");
        hashMap.put("~", "\\~");
        hashMap.put("=", "\\=");
        hashMap.put("%", "\\%");
        ESCAPE_XSI = new LookupTranslator(Collections.unmodifiableMap(hashMap));
        hashMap = new HashMap<String, String>();
        hashMap.put("\\\\", "\\");
        hashMap.put("\\\"", "\"");
        hashMap.put("\\'", "'");
        hashMap.put("\\", "");
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator(Collections.unmodifiableMap(hashMap)));
        UNESCAPE_JSON = UNESCAPE_JAVA;
        UNESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_XML = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.APOS_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_CSV = new CsvTranslators.CsvUnescaper();
        UNESCAPE_XSI = new XsiUnescaper();
    }

    public static final class Builder {
        private final StringBuilder sb = new StringBuilder();
        private final CharSequenceTranslator translator;

        private Builder(CharSequenceTranslator translator) {
            this.translator = translator;
        }

        public final Builder escape(String input) {
            this.sb.append(this.translator.translate(input));
            return this;
        }

        public final Builder append(String input) {
            this.sb.append(input);
            return this;
        }

        public final String toString() {
            return this.sb.toString();
        }
    }

    static class XsiUnescaper
    extends CharSequenceTranslator {
        private static final char BACKSLASH = '\\';

        XsiUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("XsiUnescaper should never reach the [1] index");
            }
            String string = input.toString();
            int n2 = 0;
            int n3 = 0;
            while (true) {
                int n4;
                if ((n4 = string.indexOf(92, n3)) == -1) {
                    if (n2 >= string.length()) break;
                    out.write(string.substring(n2));
                    break;
                }
                if (n4 > n2) {
                    out.write(string.substring(n2, n4));
                }
                n2 = n4 + 1;
                n3 = n4 + 2;
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }
}

