/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import org.apache.commons.text.diff.DeleteCommand;
import org.apache.commons.text.diff.EditScript;
import org.apache.commons.text.diff.InsertCommand;
import org.apache.commons.text.diff.KeepCommand;

public class StringsComparator {
    private final String left;
    private final String right;
    private final int[] vDown;
    private final int[] vUp;

    public StringsComparator(String left, String right) {
        this.left = left;
        this.right = right;
        int n2 = left.length() + right.length() + 2;
        this.vDown = new int[n2];
        this.vUp = new int[n2];
    }

    public EditScript<Character> getScript() {
        EditScript<Character> editScript = new EditScript<Character>();
        this.buildScript(0, this.left.length(), 0, this.right.length(), editScript);
        return editScript;
    }

    private void buildScript(int start1, int end1, int start2, int end2, EditScript<Character> script) {
        while (true) {
            int n2;
            Snake snake;
            if ((snake = this.getMiddleSnake(start1, end1, start2, end2)) == null || snake.getStart() == end1 && snake.getDiag() == end1 - end2 || snake.getEnd() == start1 && snake.getDiag() == start1 - start2) {
                n2 = start1;
                int n3 = start2;
                while (n2 < end1 || n3 < end2) {
                    if (n2 < end1 && n3 < end2 && this.left.charAt(n2) == this.right.charAt(n3)) {
                        script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(n2))));
                        ++n2;
                        ++n3;
                        continue;
                    }
                    if (end1 - start1 > end2 - start2) {
                        script.append(new DeleteCommand<Character>(Character.valueOf(this.left.charAt(n2))));
                        ++n2;
                        continue;
                    }
                    script.append(new InsertCommand<Character>(Character.valueOf(this.right.charAt(n3))));
                    ++n3;
                }
                return;
            }
            this.buildScript(start1, snake.getStart(), start2, snake.getStart() - snake.getDiag(), script);
            for (n2 = snake.getStart(); n2 < snake.getEnd(); ++n2) {
                script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(n2))));
            }
            start2 = snake.getEnd() - snake.getDiag();
            start1 = snake.getEnd();
        }
    }

    private Snake getMiddleSnake(int start1, int end1, int start2, int end2) {
        int n2 = end1 - start1;
        int n3 = end2 - start2;
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        int n4 = n2 - n3;
        int n5 = n3 + n2;
        int n6 = (n5 % 2 == 0 ? n5 : n5 + 1) / 2;
        this.vDown[n6 + 1] = start1;
        this.vUp[n6 + 1] = end1 + 1;
        for (int i2 = 0; i2 <= n6; ++i2) {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = -i2; n10 <= i2; n10 += 2) {
                n9 = n10 + n6;
                this.vDown[n9] = n10 == -i2 || n10 != i2 && this.vDown[n9 - 1] < this.vDown[n9 + 1] ? this.vDown[n9 + 1] : this.vDown[n9 - 1] + 1;
                n8 = this.vDown[n9];
                for (n7 = n8 - start1 + start2 - n10; n8 < end1 && n7 < end2 && this.left.charAt(n8) == this.right.charAt(n7); ++n7) {
                    this.vDown[n9] = ++n8;
                }
                if (n4 % 2 == 0 || n4 - i2 > n10 || n10 > n4 + i2 || this.vUp[n9 - n4] > this.vDown[n9]) continue;
                StringsComparator stringsComparator = this;
                return stringsComparator.buildSnake(stringsComparator.vUp[n9 - n4], n10 + start1 - start2, end1, end2);
            }
            for (n10 = n4 - i2; n10 <= n4 + i2; n10 += 2) {
                n9 = n10 + n6 - n4;
                this.vUp[n9] = n10 == n4 - i2 || n10 != n4 + i2 && this.vUp[n9 + 1] <= this.vUp[n9 - 1] ? this.vUp[n9 + 1] - 1 : this.vUp[n9 - 1];
                n8 = this.vUp[n9] - 1;
                for (n7 = n8 - start1 + start2 - n10; n8 >= start1 && n7 >= start2 && this.left.charAt(n8) == this.right.charAt(n7); --n7) {
                    this.vUp[n9] = n8--;
                }
                if (n4 % 2 != 0 || -i2 > n10 || n10 > i2 || this.vUp[n9] > this.vDown[n9 + n4]) continue;
                StringsComparator stringsComparator = this;
                return stringsComparator.buildSnake(stringsComparator.vUp[n9], n10 + start1 - start2, end1, end2);
            }
        }
        throw new RuntimeException("Internal Error");
    }

    private Snake buildSnake(int start, int diag, int end1, int end2) {
        int n2;
        for (n2 = start; n2 - diag < end2 && n2 < end1 && this.left.charAt(n2) == this.right.charAt(n2 - diag); ++n2) {
        }
        return new Snake(start, n2, diag);
    }

    private static class Snake {
        private final int start;
        private final int end;
        private final int diag;

        public Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getDiag() {
            return this.diag;
        }
    }
}

