/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Map;
import org.apache.commons.text.similarity.CosineSimilarity;
import org.apache.commons.text.similarity.Counter;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.RegexTokenizer;
import org.apache.commons.text.similarity.Tokenizer;

public class CosineDistance
implements EditDistance<Double> {
    private final Tokenizer<CharSequence> tokenizer = new RegexTokenizer();
    private final CosineSimilarity cosineSimilarity = new CosineSimilarity();

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        CharSequence[] charSequenceArray = this.tokenizer.tokenize(left);
        CharSequence[] charSequenceArray2 = this.tokenizer.tokenize(right);
        Map<CharSequence, Integer> map = Counter.of(charSequenceArray);
        Map<CharSequence, Integer> map2 = Counter.of(charSequenceArray2);
        double d2 = this.cosineSimilarity.cosineSimilarity(map, map2);
        return 1.0 - d2;
    }
}

