/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDate
extends BaseLocal
implements Serializable,
ReadablePartial {
    private static final long serialVersionUID = -8775358157899L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final Set<DurationFieldType> DATE_DURATION_TYPES = new HashSet<DurationFieldType>();
    private final long iLocalMillis;
    private final Chronology iChronology;
    private transient int iHash;

    public static LocalDate now() {
        return new LocalDate();
    }

    public static LocalDate now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDate(dateTimeZone);
    }

    public static LocalDate now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDate(chronology);
    }

    @FromString
    public static LocalDate parse(String string) {
        return LocalDate.parse(string, ISODateTimeFormat.localDateParser());
    }

    public static LocalDate parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseLocalDate(string);
    }

    public static LocalDate fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        return new LocalDate(n2 == 1 ? n3 : 1 - n3, calendar.get(2) + 1, calendar.get(5));
    }

    public static LocalDate fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date.getTime() < 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return LocalDate.fromCalendarFields(gregorianCalendar);
        }
        return new LocalDate(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public LocalDate() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalDate(DateTimeZone dateTimeZone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public LocalDate(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalDate(long l2) {
        this(l2, (Chronology)ISOChronology.getInstance());
    }

    public LocalDate(long l2, DateTimeZone dateTimeZone) {
        this(l2, (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public LocalDate(long l2, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        long l3 = chronology.getZone().getMillisKeepLocal(DateTimeZone.UTC, l2);
        chronology = chronology.withUTC();
        this.iLocalMillis = chronology.dayOfMonth().roundFloor(l3);
        this.iChronology = chronology;
    }

    public LocalDate(Object object) {
        this(object, (Chronology)null);
    }

    public LocalDate(Object object, DateTimeZone dateTimeZone) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology = partialConverter.getChronology(object, dateTimeZone);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    public LocalDate(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    public LocalDate(int n2, int n3, int n4) {
        this(n2, n3, n4, ISOChronology.getInstanceUTC());
    }

    public LocalDate(int n2, int n3, int n4, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology).withUTC();
        long l2 = chronology.getDateTimeMillis(n2, n3, n4, 0);
        this.iChronology = chronology;
        this.iLocalMillis = l2;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new LocalDate(this.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(this.iChronology.getZone())) {
            return new LocalDate(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    public final int size() {
        return 3;
    }

    protected final DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            case 0: {
                return chronology.year();
            }
            case 1: {
                return chronology.monthOfYear();
            }
            case 2: {
                return chronology.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    public final int getValue(int n2) {
        switch (n2) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n2);
    }

    public final int get(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return dateTimeFieldType.getField(this.getChronology()).get(this.getLocalMillis());
    }

    public final boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            return false;
        }
        DurationFieldType durationFieldType = dateTimeFieldType.getDurationType();
        if (DATE_DURATION_TYPES.contains(durationFieldType) || durationFieldType.getField(this.getChronology()).getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return dateTimeFieldType.getField(this.getChronology()).isSupported();
        }
        return false;
    }

    public final boolean isSupported(DurationFieldType durationFieldType) {
        if (durationFieldType == null) {
            return false;
        }
        DurationField durationField = durationFieldType.getField(this.getChronology());
        if (DATE_DURATION_TYPES.contains(durationFieldType) || durationField.getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return durationField.isSupported();
        }
        return false;
    }

    protected final long getLocalMillis() {
        return this.iLocalMillis;
    }

    public final Chronology getChronology() {
        return this.iChronology;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            if (this.iChronology.equals(localDate.iChronology)) {
                return this.iLocalMillis == localDate.iLocalMillis;
            }
        }
        return super.equals(object);
    }

    public final int hashCode() {
        int n2 = this.iHash;
        if (n2 == 0) {
            n2 = this.iHash = super.hashCode();
        }
        return n2;
    }

    public final int compareTo(ReadablePartial readablePartial) {
        if (this == readablePartial) {
            return 0;
        }
        if (readablePartial instanceof LocalDate) {
            LocalDate localDate = (LocalDate)readablePartial;
            if (this.iChronology.equals(localDate.iChronology)) {
                if (this.iLocalMillis < localDate.iLocalMillis) {
                    return -1;
                }
                if (this.iLocalMillis == localDate.iLocalMillis) {
                    return 0;
                }
                return 1;
            }
        }
        return super.compareTo(readablePartial);
    }

    public final DateTime toDateTimeAtStartOfDay() {
        return this.toDateTimeAtStartOfDay(null);
    }

    public final DateTime toDateTimeAtStartOfDay(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        long l2 = this.getLocalMillis() + 21600000L;
        long l3 = dateTimeZone.convertLocalToUTC(l2, false);
        l3 = chronology.dayOfMonth().roundFloor(l3);
        return new DateTime(l3, chronology);
    }

    @Deprecated
    public final DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    @Deprecated
    public final DateTime toDateTimeAtMidnight(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chronology);
    }

    public final DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public final DateTime toDateTimeAtCurrentTime(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    @Deprecated
    public final DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    @Deprecated
    public final DateMidnight toDateMidnight(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chronology);
    }

    public final LocalDateTime toLocalDateTime(LocalTime localTime) {
        if (localTime == null) {
            throw new IllegalArgumentException("The time must not be null");
        }
        if (this.getChronology() != localTime.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        long l2 = this.getLocalMillis() + localTime.getLocalMillis();
        return new LocalDateTime(l2, this.getChronology());
    }

    public final DateTime toDateTime(LocalTime localTime) {
        return this.toDateTime(localTime, null);
    }

    public final DateTime toDateTime(LocalTime localTime, DateTimeZone dateTimeZone) {
        if (localTime == null) {
            return this.toDateTimeAtCurrentTime(dateTimeZone);
        }
        if (this.getChronology() != localTime.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), chronology);
    }

    public final Interval toInterval() {
        return this.toInterval(null);
    }

    public final Interval toInterval(DateTimeZone dateTimeZone) {
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        DateTime dateTime = this.toDateTimeAtStartOfDay(dateTimeZone);
        DateTime dateTime2 = this.plusDays(1).toDateTimeAtStartOfDay(dateTimeZone);
        return new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
    }

    public final Date toDate() {
        Date date;
        int n2 = this.getDayOfMonth();
        Date date2 = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, n2);
        LocalDate localDate = LocalDate.fromDateFields(date2);
        if (localDate.isBefore(this)) {
            while (!localDate.equals(this)) {
                Date date3 = date2;
                date3.setTime(date3.getTime() + 3600000L);
                localDate = LocalDate.fromDateFields(date2);
            }
            while (date2.getDate() == n2) {
                Date date4 = date2;
                date4.setTime(date4.getTime() - 1000L);
            }
            Date date5 = date2;
            date5.setTime(date5.getTime() + 1000L);
        } else if (localDate.equals(this) && (date = new Date(date2.getTime() - (long)TimeZone.getDefault().getDSTSavings())).getDate() == n2) {
            date2 = date;
        }
        return date2;
    }

    final LocalDate withLocalMillis(long l2) {
        l2 = this.iChronology.dayOfMonth().roundFloor(l2);
        if (l2 == this.getLocalMillis()) {
            return this;
        }
        return new LocalDate(l2, this.getChronology());
    }

    public final LocalDate withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().set(readablePartial, this.getLocalMillis()));
    }

    public final LocalDate withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        long l2 = dateTimeFieldType.getField(this.getChronology()).set(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(durationFieldType)) {
            throw new IllegalArgumentException("Field '" + durationFieldType + "' is not supported");
        }
        if (n2 == 0) {
            return this;
        }
        long l2 = durationFieldType.getField(this.getChronology()).add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        long l2 = this.getLocalMillis();
        Chronology chronology = this.getChronology();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            long l3 = FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2);
            DurationFieldType durationFieldType = readablePeriod.getFieldType(i2);
            if (!this.isSupported(durationFieldType)) continue;
            l2 = durationFieldType.getField(chronology).add(l2, l3);
        }
        return this.withLocalMillis(l2);
    }

    public final LocalDate plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public final LocalDate plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public final LocalDate minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final LocalDate minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getLocalMillis(), n2);
        return this.withLocalMillis(l2);
    }

    public final Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeFieldType.getField(this.getChronology()));
    }

    public final int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public final int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public final int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public final int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public final int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public final int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public final int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public final int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public final int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public final int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public final int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public final LocalDate withEra(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().era().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withCenturyOfEra(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().centuryOfEra().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withYearOfEra(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().yearOfEra().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withYearOfCentury(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().yearOfCentury().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withYear(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().year().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withWeekyear(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().weekyear().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withMonthOfYear(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().monthOfYear().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withWeekOfWeekyear(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().weekOfWeekyear().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withDayOfYear(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().dayOfYear().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withDayOfMonth(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().dayOfMonth().set(this.getLocalMillis(), n2));
    }

    public final LocalDate withDayOfWeek(int n2) {
        LocalDate localDate = this;
        return localDate.withLocalMillis(localDate.getChronology().dayOfWeek().set(this.getLocalMillis(), n2));
    }

    public final Property era() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().era());
    }

    public final Property centuryOfEra() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().centuryOfEra());
    }

    public final Property yearOfCentury() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().yearOfCentury());
    }

    public final Property yearOfEra() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().yearOfEra());
    }

    public final Property year() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().year());
    }

    public final Property weekyear() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().weekyear());
    }

    public final Property monthOfYear() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().monthOfYear());
    }

    public final Property weekOfWeekyear() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().weekOfWeekyear());
    }

    public final Property dayOfYear() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().dayOfYear());
    }

    public final Property dayOfMonth() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().dayOfMonth());
    }

    public final Property dayOfWeek() {
        LocalDate localDate = this;
        return new Property(localDate, localDate.getChronology().dayOfWeek());
    }

    @ToString
    public final String toString() {
        return ISODateTimeFormat.date().print(this);
    }

    public final String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).print(this);
    }

    public final String toString(String string, Locale locale) throws IllegalArgumentException {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).withLocale(locale).print(this);
    }

    static {
        DATE_DURATION_TYPES.add(DurationFieldType.days());
        DATE_DURATION_TYPES.add(DurationFieldType.weeks());
        DATE_DURATION_TYPES.add(DurationFieldType.months());
        DATE_DURATION_TYPES.add(DurationFieldType.weekyears());
        DATE_DURATION_TYPES.add(DurationFieldType.years());
        DATE_DURATION_TYPES.add(DurationFieldType.centuries());
        DATE_DURATION_TYPES.add(DurationFieldType.eras());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -3193829732634L;
        private transient LocalDate iInstant;
        private transient DateTimeField iField;

        Property(LocalDate localDate, DateTimeField dateTimeField) {
            this.iInstant = localDate;
            this.iField = dateTimeField;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalDate)objectInputStream.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)objectInputStream.readObject();
            this.iField = dateTimeFieldType.getField(this.iInstant.getChronology());
        }

        public final DateTimeField getField() {
            return this.iField;
        }

        protected final long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        protected final Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public final LocalDate getLocalDate() {
            return this.iInstant;
        }

        public final LocalDate addToCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDate addWrapFieldToCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDate setCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), n2));
        }

        public final LocalDate setCopy(String string, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), string, locale));
        }

        public final LocalDate setCopy(String string) {
            return this.setCopy(string, null);
        }

        public final LocalDate withMaximumValue() {
            Property property = this;
            return property.setCopy(property.getMaximumValue());
        }

        public final LocalDate withMinimumValue() {
            Property property = this;
            return property.setCopy(property.getMinimumValue());
        }

        public final LocalDate roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public final LocalDate roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public final LocalDate roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public final LocalDate roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public final LocalDate roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }
    }
}

