/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.field.FieldUtils;

public class MutableInterval
extends BaseInterval
implements Serializable,
Cloneable,
ReadWritableInterval {
    private static final long serialVersionUID = -5982824024992428470L;

    public static MutableInterval parse(String string) {
        return new MutableInterval(string);
    }

    public MutableInterval() {
        super(0L, 0L, null);
    }

    public MutableInterval(long l2, long l3) {
        super(l2, l3, null);
    }

    public MutableInterval(long l2, long l3, Chronology chronology) {
        super(l2, l3, chronology);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        super(readableInstant, readableDuration);
    }

    public MutableInterval(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        super(readableDuration, readableInstant);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadablePeriod readablePeriod) {
        super(readableInstant, readablePeriod);
    }

    public MutableInterval(ReadablePeriod readablePeriod, ReadableInstant readableInstant) {
        super(readablePeriod, readableInstant);
    }

    public MutableInterval(Object object) {
        super(object, null);
    }

    public MutableInterval(Object object, Chronology chronology) {
        super(object, chronology);
    }

    public void setInterval(long l2, long l3) {
        super.setInterval(l2, l3, this.getChronology());
    }

    public void setInterval(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            throw new IllegalArgumentException("Interval must not be null");
        }
        long l2 = readableInterval.getStartMillis();
        long l3 = readableInterval.getEndMillis();
        Chronology chronology = readableInterval.getChronology();
        super.setInterval(l2, l3, chronology);
    }

    public void setInterval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        if (readableInstant == null && readableInstant2 == null) {
            long l2;
            long l3 = l2 = DateTimeUtils.currentTimeMillis();
            this.setInterval(l3, l3);
            return;
        }
        long l4 = DateTimeUtils.getInstantMillis(readableInstant);
        long l5 = DateTimeUtils.getInstantMillis(readableInstant2);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        super.setInterval(l4, l5, chronology);
    }

    public void setChronology(Chronology chronology) {
        MutableInterval mutableInterval = this;
        super.setInterval(mutableInterval.getStartMillis(), this.getEndMillis(), chronology);
    }

    public void setStartMillis(long l2) {
        super.setInterval(l2, this.getEndMillis(), this.getChronology());
    }

    public void setStart(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        super.setInterval(l2, this.getEndMillis(), this.getChronology());
    }

    public void setEndMillis(long l2) {
        MutableInterval mutableInterval = this;
        super.setInterval(mutableInterval.getStartMillis(), l2, this.getChronology());
    }

    public void setEnd(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        MutableInterval mutableInterval = this;
        super.setInterval(mutableInterval.getStartMillis(), l2, this.getChronology());
    }

    public void setDurationAfterStart(long l2) {
        MutableInterval mutableInterval = this;
        mutableInterval.setEndMillis(FieldUtils.safeAdd(mutableInterval.getStartMillis(), l2));
    }

    public void setDurationBeforeEnd(long l2) {
        MutableInterval mutableInterval = this;
        mutableInterval.setStartMillis(FieldUtils.safeAdd(mutableInterval.getEndMillis(), -l2));
    }

    public void setDurationAfterStart(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        MutableInterval mutableInterval = this;
        mutableInterval.setEndMillis(FieldUtils.safeAdd(mutableInterval.getStartMillis(), l2));
    }

    public void setDurationBeforeEnd(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        MutableInterval mutableInterval = this;
        mutableInterval.setStartMillis(FieldUtils.safeAdd(mutableInterval.getEndMillis(), -l2));
    }

    public void setPeriodAfterStart(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            MutableInterval mutableInterval = this;
            mutableInterval.setEndMillis(mutableInterval.getStartMillis());
            return;
        }
        MutableInterval mutableInterval = this;
        mutableInterval.setEndMillis(mutableInterval.getChronology().add(readablePeriod, this.getStartMillis(), 1));
    }

    public void setPeriodBeforeEnd(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            MutableInterval mutableInterval = this;
            mutableInterval.setStartMillis(mutableInterval.getEndMillis());
            return;
        }
        MutableInterval mutableInterval = this;
        mutableInterval.setStartMillis(mutableInterval.getChronology().add(readablePeriod, this.getEndMillis(), -1));
    }

    public MutableInterval copy() {
        return (MutableInterval)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }
}

