/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GJCacheKey;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class GJChronology
extends AssembledChronology {
    private static final long serialVersionUID = -2545574827706931671L;
    static final Instant DEFAULT_CUTOVER = new Instant(-12219292800000L);
    private static final ConcurrentHashMap<GJCacheKey, GJChronology> cCache = new ConcurrentHashMap();
    private JulianChronology iJulianChronology;
    private GregorianChronology iGregorianChronology;
    private Instant iCutoverInstant;
    private long iCutoverMillis;
    private long iGapDuration;

    private static long convertByYear(long l2, Chronology chronology, Chronology chronology2) {
        return chronology2.getDateTimeMillis(chronology.year().get(l2), chronology.monthOfYear().get(l2), chronology.dayOfMonth().get(l2), chronology.millisOfDay().get(l2));
    }

    private static long convertByWeekyear(long l2, Chronology chronology, Chronology chronology2) {
        long l3 = chronology2.weekyear().set(0L, chronology.weekyear().get(l2));
        l3 = chronology2.weekOfWeekyear().set(l3, chronology.weekOfWeekyear().get(l2));
        l3 = chronology2.dayOfWeek().set(l3, chronology.dayOfWeek().get(l2));
        l3 = chronology2.millisOfDay().set(l3, chronology.millisOfDay().get(l2));
        return l3;
    }

    public static GJChronology getInstanceUTC() {
        return GJChronology.getInstance(DateTimeZone.UTC, DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance() {
        return GJChronology.getInstance(DateTimeZone.getDefault(), DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone) {
        return GJChronology.getInstance(dateTimeZone, DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone, ReadableInstant readableInstant) {
        return GJChronology.getInstance(dateTimeZone, readableInstant, 4);
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone, ReadableInstant readableInstant, int n2) {
        Object object;
        Instant instant;
        dateTimeZone = DateTimeUtils.getZone(dateTimeZone);
        if (readableInstant == null) {
            instant = DEFAULT_CUTOVER;
        } else {
            instant = readableInstant.toInstant();
            object = new LocalDate(instant.getMillis(), (Chronology)GregorianChronology.getInstance(dateTimeZone));
            if (((LocalDate)object).getYear() <= 0) {
                throw new IllegalArgumentException("Cutover too early. Must be on or after 0001-01-01.");
            }
        }
        object = new GJCacheKey(dateTimeZone, instant, n2);
        GJChronology gJChronology = cCache.get(object);
        if (gJChronology == null) {
            if (dateTimeZone == DateTimeZone.UTC) {
                gJChronology = new GJChronology(JulianChronology.getInstance(dateTimeZone, n2), GregorianChronology.getInstance(dateTimeZone, n2), instant);
            } else {
                gJChronology = GJChronology.getInstance(DateTimeZone.UTC, instant, n2);
                gJChronology = new GJChronology(ZonedChronology.getInstance(gJChronology, dateTimeZone), gJChronology.iJulianChronology, gJChronology.iGregorianChronology, gJChronology.iCutoverInstant);
            }
            GJChronology gJChronology2 = cCache.putIfAbsent((GJCacheKey)object, gJChronology);
            if (gJChronology2 != null) {
                gJChronology = gJChronology2;
            }
        }
        return gJChronology;
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone, long l2, int n2) {
        Instant instant = l2 == DEFAULT_CUTOVER.getMillis() ? null : new Instant(l2);
        return GJChronology.getInstance(dateTimeZone, instant, n2);
    }

    private GJChronology(JulianChronology julianChronology, GregorianChronology gregorianChronology, Instant instant) {
        super(null, new Object[]{julianChronology, gregorianChronology, instant});
    }

    private GJChronology(Chronology chronology, JulianChronology julianChronology, GregorianChronology gregorianChronology, Instant instant) {
        super(chronology, new Object[]{julianChronology, gregorianChronology, instant});
    }

    private Object readResolve() {
        return GJChronology.getInstance(this.getZone(), this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    public final DateTimeZone getZone() {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getZone();
        }
        return DateTimeZone.UTC;
    }

    public final Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    public final Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return GJChronology.getInstance(dateTimeZone, this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    public final long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(n2, n3, n4, n5);
        }
        long l2 = this.iGregorianChronology.getDateTimeMillis(n2, n3, n4, n5);
        if (l2 < this.iCutoverMillis && (l2 = this.iJulianChronology.getDateTimeMillis(n2, n3, n4, n5)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return l2;
    }

    public final long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        long l2;
        block5: {
            Chronology chronology = this.getBase();
            if (chronology != null) {
                return chronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
            }
            try {
                l2 = this.iGregorianChronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
            }
            catch (IllegalFieldValueException illegalFieldValueException) {
                if (n3 != 2 || n4 != 29) {
                    throw illegalFieldValueException;
                }
                l2 = this.iGregorianChronology.getDateTimeMillis(n2, n3, 28, n5, n6, n7, n8);
                if (l2 < this.iCutoverMillis) break block5;
                throw illegalFieldValueException;
            }
        }
        if (l2 < this.iCutoverMillis && (l2 = this.iJulianChronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8)) >= this.iCutoverMillis) {
            throw new IllegalArgumentException("Specified date does not exist");
        }
        return l2;
    }

    public final Instant getGregorianCutover() {
        return this.iCutoverInstant;
    }

    public final int getMinimumDaysInFirstWeek() {
        return this.iGregorianChronology.getMinimumDaysInFirstWeek();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GJChronology) {
            GJChronology gJChronology = (GJChronology)object;
            return this.iCutoverMillis == gJChronology.iCutoverMillis && this.getMinimumDaysInFirstWeek() == gJChronology.getMinimumDaysInFirstWeek() && this.getZone().equals(gJChronology.getZone());
        }
        return false;
    }

    public final int hashCode() {
        return "GJ".hashCode() * 11 + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek() + this.iCutoverInstant.hashCode();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("GJChronology");
        stringBuffer.append('[');
        stringBuffer.append(this.getZone().getID());
        if (this.iCutoverMillis != DEFAULT_CUTOVER.getMillis()) {
            stringBuffer.append(",cutover=");
            DateTimeFormatter dateTimeFormatter = this.withUTC().dayOfYear().remainder(this.iCutoverMillis) == 0L ? ISODateTimeFormat.date() : ISODateTimeFormat.dateTime();
            dateTimeFormatter.withChronology(this.withUTC()).printTo(stringBuffer, this.iCutoverMillis);
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            stringBuffer.append(",mdfw=");
            stringBuffer.append(this.getMinimumDaysInFirstWeek());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected final void assemble(AssembledChronology.Fields fields) {
        Object[] objectArray = (Object[])this.getParam();
        JulianChronology julianChronology = (JulianChronology)objectArray[0];
        GregorianChronology gregorianChronology = (GregorianChronology)objectArray[1];
        Instant instant = (Instant)objectArray[2];
        this.iCutoverMillis = instant.getMillis();
        this.iJulianChronology = julianChronology;
        this.iGregorianChronology = gregorianChronology;
        this.iCutoverInstant = instant;
        if (this.getBase() != null) {
            return;
        }
        if (julianChronology.getMinimumDaysInFirstWeek() != gregorianChronology.getMinimumDaysInFirstWeek()) {
            throw new IllegalArgumentException();
        }
        GJChronology gJChronology = this;
        this.iGapDuration = this.iCutoverMillis - gJChronology.julianToGregorianByYear(gJChronology.iCutoverMillis);
        fields.copyFieldsFrom(gregorianChronology);
        if (gregorianChronology.millisOfDay().get(this.iCutoverMillis) == 0) {
            fields.millisOfSecond = new CutoverField(julianChronology.millisOfSecond(), fields.millisOfSecond, this.iCutoverMillis);
            fields.millisOfDay = new CutoverField(julianChronology.millisOfDay(), fields.millisOfDay, this.iCutoverMillis);
            fields.secondOfMinute = new CutoverField(julianChronology.secondOfMinute(), fields.secondOfMinute, this.iCutoverMillis);
            fields.secondOfDay = new CutoverField(julianChronology.secondOfDay(), fields.secondOfDay, this.iCutoverMillis);
            fields.minuteOfHour = new CutoverField(julianChronology.minuteOfHour(), fields.minuteOfHour, this.iCutoverMillis);
            fields.minuteOfDay = new CutoverField(julianChronology.minuteOfDay(), fields.minuteOfDay, this.iCutoverMillis);
            fields.hourOfDay = new CutoverField(julianChronology.hourOfDay(), fields.hourOfDay, this.iCutoverMillis);
            fields.hourOfHalfday = new CutoverField(julianChronology.hourOfHalfday(), fields.hourOfHalfday, this.iCutoverMillis);
            fields.clockhourOfDay = new CutoverField(julianChronology.clockhourOfDay(), fields.clockhourOfDay, this.iCutoverMillis);
            fields.clockhourOfHalfday = new CutoverField(julianChronology.clockhourOfHalfday(), fields.clockhourOfHalfday, this.iCutoverMillis);
            fields.halfdayOfDay = new CutoverField(julianChronology.halfdayOfDay(), fields.halfdayOfDay, this.iCutoverMillis);
        }
        fields.era = new CutoverField(julianChronology.era(), fields.era, this.iCutoverMillis);
        fields.year = new ImpreciseCutoverField(julianChronology.year(), fields.year, this.iCutoverMillis);
        fields.years = fields.year.getDurationField();
        fields.yearOfEra = new ImpreciseCutoverField(julianChronology.yearOfEra(), fields.yearOfEra, fields.years, this.iCutoverMillis);
        fields.centuryOfEra = new ImpreciseCutoverField(julianChronology.centuryOfEra(), fields.centuryOfEra, this.iCutoverMillis);
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.yearOfCentury = new ImpreciseCutoverField(julianChronology.yearOfCentury(), fields.yearOfCentury, fields.years, fields.centuries, this.iCutoverMillis);
        fields.monthOfYear = new ImpreciseCutoverField(julianChronology.monthOfYear(), fields.monthOfYear, null, fields.years, this.iCutoverMillis);
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyear = new ImpreciseCutoverField(julianChronology.weekyear(), fields.weekyear, null, this.iCutoverMillis, true);
        fields.weekyears = fields.weekyear.getDurationField();
        fields.weekyearOfCentury = new ImpreciseCutoverField(julianChronology.weekyearOfCentury(), fields.weekyearOfCentury, fields.weekyears, fields.centuries, this.iCutoverMillis);
        long l2 = gregorianChronology.year().roundCeiling(this.iCutoverMillis);
        fields.dayOfYear = new CutoverField(julianChronology.dayOfYear(), fields.dayOfYear, fields.years, l2, false);
        l2 = gregorianChronology.weekyear().roundCeiling(this.iCutoverMillis);
        fields.weekOfWeekyear = new CutoverField(julianChronology.weekOfWeekyear(), fields.weekOfWeekyear, fields.weekyears, l2, true);
        CutoverField cutoverField = new CutoverField(julianChronology.dayOfMonth(), fields.dayOfMonth, this.iCutoverMillis);
        new CutoverField(julianChronology.dayOfMonth(), fields.dayOfMonth, this.iCutoverMillis).iRangeDurationField = fields.months;
        fields.dayOfMonth = cutoverField;
    }

    final long julianToGregorianByYear(long l2) {
        return GJChronology.convertByYear(l2, this.iJulianChronology, this.iGregorianChronology);
    }

    final long gregorianToJulianByYear(long l2) {
        return GJChronology.convertByYear(l2, this.iGregorianChronology, this.iJulianChronology);
    }

    final long julianToGregorianByWeekyear(long l2) {
        return GJChronology.convertByWeekyear(l2, this.iJulianChronology, this.iGregorianChronology);
    }

    final long gregorianToJulianByWeekyear(long l2) {
        return GJChronology.convertByWeekyear(l2, this.iGregorianChronology, this.iJulianChronology);
    }

    private static class LinkedDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 4097975388007713084L;
        private final ImpreciseCutoverField iField;

        LinkedDurationField(DurationField durationField, ImpreciseCutoverField impreciseCutoverField) {
            DurationField durationField2 = durationField;
            super(durationField2, durationField2.getType());
            this.iField = impreciseCutoverField;
        }

        public long add(long l2, int n2) {
            return this.iField.add(l2, n2);
        }

        public long add(long l2, long l3) {
            return this.iField.add(l2, l3);
        }

        public int getDifference(long l2, long l3) {
            return this.iField.getDifference(l2, l3);
        }

        public long getDifferenceAsLong(long l2, long l3) {
            return this.iField.getDifferenceAsLong(l2, l3);
        }
    }

    private final class ImpreciseCutoverField
    extends CutoverField {
        private static final long serialVersionUID = 3410248757173576441L;

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2) {
            this(dateTimeField, dateTimeField2, null, l2, false);
        }

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, long l2) {
            this(dateTimeField, dateTimeField2, durationField, l2, false);
        }

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, DurationField durationField2, long l2) {
            this(dateTimeField, dateTimeField2, durationField, l2, false);
            this.iRangeDurationField = durationField2;
        }

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, long l2, boolean bl) {
            super(dateTimeField, dateTimeField2, l2, bl);
            if (durationField == null) {
                durationField = new LinkedDurationField(this.iDurationField, this);
            }
            this.iDurationField = durationField;
        }

        public final long add(long l2, int n2) {
            if (l2 >= this.iCutover) {
                if ((l2 = this.iGregorianField.add(l2, n2)) < this.iCutover && l2 + GJChronology.this.iGapDuration < this.iCutover) {
                    if (this.iConvertByWeekyear) {
                        int n3 = GJChronology.this.iGregorianChronology.weekyear().get(l2);
                        if (n3 <= 0) {
                            l2 = GJChronology.this.iGregorianChronology.weekyear().add(l2, -1);
                        }
                    } else {
                        int n4 = GJChronology.this.iGregorianChronology.year().get(l2);
                        if (n4 <= 0) {
                            l2 = GJChronology.this.iGregorianChronology.year().add(l2, -1);
                        }
                    }
                    l2 = this.gregorianToJulian(l2);
                }
            } else if ((l2 = this.iJulianField.add(l2, n2)) >= this.iCutover && l2 - GJChronology.this.iGapDuration >= this.iCutover) {
                l2 = this.julianToGregorian(l2);
            }
            return l2;
        }

        public final long add(long l2, long l3) {
            if (l2 >= this.iCutover) {
                if ((l2 = this.iGregorianField.add(l2, l3)) < this.iCutover && l2 + GJChronology.this.iGapDuration < this.iCutover) {
                    if (this.iConvertByWeekyear) {
                        int n2 = GJChronology.this.iGregorianChronology.weekyear().get(l2);
                        if (n2 <= 0) {
                            l2 = GJChronology.this.iGregorianChronology.weekyear().add(l2, -1);
                        }
                    } else {
                        int n3 = GJChronology.this.iGregorianChronology.year().get(l2);
                        if (n3 <= 0) {
                            l2 = GJChronology.this.iGregorianChronology.year().add(l2, -1);
                        }
                    }
                    l2 = this.gregorianToJulian(l2);
                }
            } else if ((l2 = this.iJulianField.add(l2, l3)) >= this.iCutover && l2 - GJChronology.this.iGapDuration >= this.iCutover) {
                l2 = this.julianToGregorian(l2);
            }
            return l2;
        }

        public final int getDifference(long l2, long l3) {
            if (l2 >= this.iCutover) {
                if (l3 >= this.iCutover) {
                    return this.iGregorianField.getDifference(l2, l3);
                }
                l2 = this.gregorianToJulian(l2);
                return this.iJulianField.getDifference(l2, l3);
            }
            if (l3 < this.iCutover) {
                return this.iJulianField.getDifference(l2, l3);
            }
            l2 = this.julianToGregorian(l2);
            return this.iGregorianField.getDifference(l2, l3);
        }

        public final long getDifferenceAsLong(long l2, long l3) {
            if (l2 >= this.iCutover) {
                if (l3 >= this.iCutover) {
                    return this.iGregorianField.getDifferenceAsLong(l2, l3);
                }
                l2 = this.gregorianToJulian(l2);
                return this.iJulianField.getDifferenceAsLong(l2, l3);
            }
            if (l3 < this.iCutover) {
                return this.iJulianField.getDifferenceAsLong(l2, l3);
            }
            l2 = this.julianToGregorian(l2);
            return this.iGregorianField.getDifferenceAsLong(l2, l3);
        }

        public final int getMinimumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMinimumValue(l2);
            }
            return this.iJulianField.getMinimumValue(l2);
        }

        public final int getMaximumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(l2);
            }
            return this.iJulianField.getMaximumValue(l2);
        }
    }

    private class CutoverField
    extends BaseDateTimeField {
        private static final long serialVersionUID = 3528501219481026402L;
        final DateTimeField iJulianField;
        final DateTimeField iGregorianField;
        final long iCutover;
        final boolean iConvertByWeekyear;
        protected DurationField iDurationField;
        protected DurationField iRangeDurationField;

        CutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2) {
            this(dateTimeField, dateTimeField2, l2, false);
        }

        CutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2, boolean bl) {
            this(dateTimeField, dateTimeField2, null, l2, bl);
        }

        CutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, long l2, boolean bl) {
            super(dateTimeField2.getType());
            this.iJulianField = dateTimeField;
            this.iGregorianField = dateTimeField2;
            this.iCutover = l2;
            this.iConvertByWeekyear = bl;
            this.iDurationField = dateTimeField2.getDurationField();
            if (durationField == null && (durationField = dateTimeField2.getRangeDurationField()) == null) {
                durationField = dateTimeField.getRangeDurationField();
            }
            this.iRangeDurationField = durationField;
        }

        public boolean isLenient() {
            return false;
        }

        public int get(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.get(l2);
            }
            return this.iJulianField.get(l2);
        }

        public String getAsText(long l2, Locale locale) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getAsText(l2, locale);
            }
            return this.iJulianField.getAsText(l2, locale);
        }

        public String getAsText(int n2, Locale locale) {
            return this.iGregorianField.getAsText(n2, locale);
        }

        public String getAsShortText(long l2, Locale locale) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getAsShortText(l2, locale);
            }
            return this.iJulianField.getAsShortText(l2, locale);
        }

        public String getAsShortText(int n2, Locale locale) {
            return this.iGregorianField.getAsShortText(n2, locale);
        }

        public long add(long l2, int n2) {
            return this.iGregorianField.add(l2, n2);
        }

        public long add(long l2, long l3) {
            return this.iGregorianField.add(l2, l3);
        }

        public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
            if (n3 == 0) {
                return nArray;
            }
            if (DateTimeUtils.isContiguous(readablePartial)) {
                long l2 = 0L;
                int n4 = readablePartial.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    l2 = readablePartial.getFieldType(i2).getField(GJChronology.this).set(l2, nArray[i2]);
                }
                l2 = this.add(l2, n3);
                return GJChronology.this.get(readablePartial, l2);
            }
            return super.add(readablePartial, n2, nArray, n3);
        }

        public int getDifference(long l2, long l3) {
            return this.iGregorianField.getDifference(l2, l3);
        }

        public long getDifferenceAsLong(long l2, long l3) {
            return this.iGregorianField.getDifferenceAsLong(l2, l3);
        }

        public long set(long l2, int n2) {
            if (l2 >= this.iCutover) {
                if ((l2 = this.iGregorianField.set(l2, n2)) < this.iCutover) {
                    if (l2 + GJChronology.this.iGapDuration < this.iCutover) {
                        l2 = this.gregorianToJulian(l2);
                    }
                    if (this.get(l2) != n2) {
                        throw new IllegalFieldValueException(this.iGregorianField.getType(), (Number)n2, null, null);
                    }
                }
            } else if ((l2 = this.iJulianField.set(l2, n2)) >= this.iCutover) {
                if (l2 - GJChronology.this.iGapDuration >= this.iCutover) {
                    l2 = this.julianToGregorian(l2);
                }
                if (this.get(l2) != n2) {
                    throw new IllegalFieldValueException(this.iJulianField.getType(), (Number)n2, null, null);
                }
            }
            return l2;
        }

        public long set(long l2, String string, Locale locale) {
            if (l2 >= this.iCutover) {
                if ((l2 = this.iGregorianField.set(l2, string, locale)) < this.iCutover && l2 + GJChronology.this.iGapDuration < this.iCutover) {
                    l2 = this.gregorianToJulian(l2);
                }
            } else if ((l2 = this.iJulianField.set(l2, string, locale)) >= this.iCutover && l2 - GJChronology.this.iGapDuration >= this.iCutover) {
                l2 = this.julianToGregorian(l2);
            }
            return l2;
        }

        public DurationField getDurationField() {
            return this.iDurationField;
        }

        public DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public boolean isLeap(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.isLeap(l2);
            }
            return this.iJulianField.isLeap(l2);
        }

        public int getLeapAmount(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getLeapAmount(l2);
            }
            return this.iJulianField.getLeapAmount(l2);
        }

        public DurationField getLeapDurationField() {
            return this.iGregorianField.getLeapDurationField();
        }

        public int getMinimumValue() {
            return this.iJulianField.getMinimumValue();
        }

        public int getMinimumValue(ReadablePartial readablePartial) {
            return this.iJulianField.getMinimumValue(readablePartial);
        }

        public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
            return this.iJulianField.getMinimumValue(readablePartial, nArray);
        }

        public int getMinimumValue(long l2) {
            if (l2 < this.iCutover) {
                return this.iJulianField.getMinimumValue(l2);
            }
            int n2 = this.iGregorianField.getMinimumValue(l2);
            if ((l2 = this.iGregorianField.set(l2, n2)) < this.iCutover) {
                n2 = this.iGregorianField.get(this.iCutover);
            }
            return n2;
        }

        public int getMaximumValue() {
            return this.iGregorianField.getMaximumValue();
        }

        public int getMaximumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(l2);
            }
            int n2 = this.iJulianField.getMaximumValue(l2);
            if ((l2 = this.iJulianField.set(l2, n2)) >= this.iCutover) {
                n2 = this.iJulianField.get(this.iJulianField.add(this.iCutover, -1));
            }
            return n2;
        }

        public int getMaximumValue(ReadablePartial readablePartial) {
            long l2 = GJChronology.getInstanceUTC().set(readablePartial, 0L);
            return this.getMaximumValue(l2);
        }

        public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
            GJChronology gJChronology = GJChronology.getInstanceUTC();
            long l2 = 0L;
            int n2 = readablePartial.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DateTimeField dateTimeField = readablePartial.getFieldType(i2).getField(gJChronology);
                if (nArray[i2] > dateTimeField.getMaximumValue(l2)) continue;
                l2 = dateTimeField.set(l2, nArray[i2]);
            }
            return this.getMaximumValue(l2);
        }

        public long roundFloor(long l2) {
            if (l2 >= this.iCutover) {
                if ((l2 = this.iGregorianField.roundFloor(l2)) < this.iCutover && l2 + GJChronology.this.iGapDuration < this.iCutover) {
                    l2 = this.gregorianToJulian(l2);
                }
            } else {
                l2 = this.iJulianField.roundFloor(l2);
            }
            return l2;
        }

        public long roundCeiling(long l2) {
            if (l2 >= this.iCutover) {
                l2 = this.iGregorianField.roundCeiling(l2);
            } else if ((l2 = this.iJulianField.roundCeiling(l2)) >= this.iCutover && l2 - GJChronology.this.iGapDuration >= this.iCutover) {
                l2 = this.julianToGregorian(l2);
            }
            return l2;
        }

        public int getMaximumTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumTextLength(locale), this.iGregorianField.getMaximumTextLength(locale));
        }

        public int getMaximumShortTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumShortTextLength(locale), this.iGregorianField.getMaximumShortTextLength(locale));
        }

        protected long julianToGregorian(long l2) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.julianToGregorianByWeekyear(l2);
            }
            return GJChronology.this.julianToGregorianByYear(l2);
        }

        protected long gregorianToJulian(long l2) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.gregorianToJulianByWeekyear(l2);
            }
            return GJChronology.this.gregorianToJulianByYear(l2);
        }
    }
}

