/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class JulianChronology
extends BasicGJChronology {
    private static final long serialVersionUID = -8731039522547897247L;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final int MIN_YEAR = -292269054;
    private static final int MAX_YEAR = 292272992;
    private static final JulianChronology INSTANCE_UTC;
    private static final ConcurrentHashMap<DateTimeZone, JulianChronology[]> cCache;

    static int adjustYearForSet(int n2) {
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)n2, null, null);
            }
            ++n2;
        }
        return n2;
    }

    public static JulianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static JulianChronology getInstance() {
        return JulianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static JulianChronology getInstance(DateTimeZone dateTimeZone) {
        return JulianChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JulianChronology getInstance(DateTimeZone dateTimeZone, int n2) {
        JulianChronology julianChronology;
        JulianChronology[] julianChronologyArray;
        JulianChronology[] julianChronologyArray2;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((julianChronologyArray2 = cCache.get(dateTimeZone)) == null && (julianChronologyArray = cCache.putIfAbsent(dateTimeZone, julianChronologyArray2 = new JulianChronology[7])) != null) {
            julianChronologyArray2 = julianChronologyArray;
        }
        try {
            julianChronology = julianChronologyArray2[n2 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + n2);
        }
        if (julianChronology != null) return julianChronology;
        julianChronologyArray = julianChronologyArray2;
        synchronized (julianChronologyArray2) {
            julianChronology = julianChronologyArray2[n2 - 1];
            if (julianChronology != null) return julianChronology;
            if (dateTimeZone == DateTimeZone.UTC) {
                julianChronology = new JulianChronology(null, null, n2);
            } else {
                julianChronology = JulianChronology.getInstance(DateTimeZone.UTC, n2);
                julianChronology = new JulianChronology(ZonedChronology.getInstance(julianChronology, dateTimeZone), null, n2);
            }
            julianChronologyArray2[n2 - 1] = julianChronology;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return julianChronology;
        }
    }

    JulianChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        int n2 = this.getMinimumDaysInFirstWeek();
        int n3 = n2 = n2 == 0 ? 4 : n2;
        if (chronology == null) {
            return JulianChronology.getInstance(DateTimeZone.UTC, n2);
        }
        return JulianChronology.getInstance(chronology.getZone(), n2);
    }

    public final Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public final Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return JulianChronology.getInstance(dateTimeZone);
    }

    final long getDateMidnightMillis(int n2, int n3, int n4) throws IllegalArgumentException {
        return super.getDateMidnightMillis(JulianChronology.adjustYearForSet(n2), n3, n4);
    }

    final boolean isLeapYear(int n2) {
        return (n2 & 3) == 0;
    }

    final long calculateFirstDayOfYearMillis(int n2) {
        int n3;
        int n4 = n2 - 1968;
        if (n4 <= 0) {
            n3 = n4 + 3 >> 2;
        } else {
            n3 = n4 >> 2;
            if (!this.isLeapYear(n2)) {
                ++n3;
            }
        }
        long l2 = ((long)n4 * 365L + (long)n3) * 86400000L;
        return l2 - 62035200000L;
    }

    final int getMinYear() {
        return -292269054;
    }

    final int getMaxYear() {
        return 292272992;
    }

    final long getAverageMillisPerYear() {
        return 31557600000L;
    }

    final long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    final long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    final long getApproxMillisAtEpochDividedByTwo() {
        return 31083663600000L;
    }

    protected final void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
        }
    }

    static {
        cCache = new ConcurrentHashMap();
        INSTANCE_UTC = JulianChronology.getInstance(DateTimeZone.UTC);
    }
}

