/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tensorflow.TensorFlow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String JNI_LIBNAME = "tensorflow_jni";

    public static void load() {
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String string = System.mapLibraryName(JNI_LIBNAME);
        String string2 = NativeLibrary.makeResourceName(string);
        NativeLibrary.log("jniResourceName: " + string2);
        InputStream inputStream = NativeLibrary.class.getClassLoader().getResourceAsStream(string2);
        String string3 = NativeLibrary.maybeAdjustForMacOS(System.mapLibraryName("tensorflow_framework"));
        String string4 = NativeLibrary.makeResourceName(string3);
        NativeLibrary.log("frameworkResourceName: " + string4);
        InputStream inputStream2 = NativeLibrary.class.getClassLoader().getResourceAsStream(string4);
        if (inputStream == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            File file = NativeLibrary.createTemporaryDirectory();
            file.deleteOnExit();
            String string5 = file.getCanonicalPath();
            if (inputStream2 != null) {
                NativeLibrary.extractResource(inputStream2, string3, string5);
            } else {
                NativeLibrary.log(string4 + " not found. This is fine assuming " + string2 + " is not built to depend on it.");
            }
            System.load(NativeLibrary.extractResource(inputStream, string, string5));
            return;
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", iOException.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(JNI_LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeLibrary.log("tryLoadLibraryFailed: " + unsatisfiedLinkError.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    private static String maybeAdjustForMacOS(String libFilename) {
        if (!System.getProperty("os.name").contains("OS X")) {
            return libFilename;
        }
        ClassLoader classLoader = NativeLibrary.class.getClassLoader();
        if (classLoader.getResource(NativeLibrary.makeResourceName(libFilename)) != null) {
            return libFilename;
        }
        if (!libFilename.endsWith(".dylib")) {
            return libFilename;
        }
        return libFilename.substring(0, libFilename.length() - 6) + ".so";
    }

    private static String extractResource(InputStream resource, String resourceName, String extractToDirectory) throws IOException {
        File file = new File(extractToDirectory, resourceName);
        file.deleteOnExit();
        String string = file.toString();
        NativeLibrary.log("extracting native library to: " + string);
        long l2 = NativeLibrary.copy(resource, file);
        NativeLibrary.log(String.format("copied %d bytes to %s", l2, string));
        return string;
    }

    private static String os() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("linux")) {
            return "linux";
        }
        if (string.contains("os x") || string.contains("darwin")) {
            return "darwin";
        }
        if (string.contains("windows")) {
            return "windows";
        }
        return string.replaceAll("\\s", "");
    }

    private static String architecture() {
        String string = System.getProperty("os.arch").toLowerCase();
        if (string.equals("amd64")) {
            return "x86_64";
        }
        return string;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + msg);
        }
    }

    private static String makeResourceName(String baseName) {
        return "org/tensorflow/native/" + String.format("%s-%s/", NativeLibrary.os(), NativeLibrary.architecture()) + baseName;
    }

    private static long copy(InputStream src, File dstFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(dstFile);
        try {
            int n2;
            byte[] byArray = new byte[0x100000];
            long l2 = 0L;
            while ((n2 = src.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
                l2 += (long)n2;
            }
            long l3 = l2;
            return l3;
        }
        finally {
            fileOutputStream.close();
            src.close();
        }
    }

    private static File createTemporaryDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = "tensorflow_native_libraries-" + System.currentTimeMillis() + "-";
        for (int i2 = 0; i2 < 1000; ++i2) {
            File file2 = new File(file, string + i2);
            if (!file2.mkdir()) continue;
            return file2;
        }
        throw new IllegalStateException("Could not create a temporary directory (tried to make " + string + "*) to extract TensorFlow native libraries.");
    }

    private NativeLibrary() {
    }
}

