/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Output;

public final class Operation {
    private final long unsafeNativeHandle;
    private final Graph graph;

    Operation(Graph g2, long unsafeNativeHandle) {
        this.graph = g2;
        this.unsafeNativeHandle = unsafeNativeHandle;
    }

    public final String name() {
        try (Graph.Reference reference = this.graph.ref();){
            String string = Operation.name(this.unsafeNativeHandle);
            return string;
        }
    }

    public final String type() {
        try (Graph.Reference reference = this.graph.ref();){
            String string = Operation.type(this.unsafeNativeHandle);
            return string;
        }
    }

    public final int numOutputs() {
        try (Graph.Reference reference = this.graph.ref();){
            int n2 = Operation.numOutputs(this.unsafeNativeHandle);
            return n2;
        }
    }

    public final int outputListLength(String name) {
        try (Graph.Reference reference = this.graph.ref();){
            int n2 = Operation.outputListLength(this.unsafeNativeHandle, name);
            return n2;
        }
    }

    public final Output<?>[] outputList(int idx, int length) {
        Output[] outputArray = new Output[length];
        for (int i2 = 0; i2 < length; ++i2) {
            outputArray[i2] = this.output(idx + i2);
        }
        return outputArray;
    }

    public final <T> Output<T> output(int idx) {
        return new Output(this, idx);
    }

    public final int hashCode() {
        return Long.valueOf(this.unsafeNativeHandle).hashCode();
    }

    public final boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)o2;
        if (this.graph != operation.graph) {
            return false;
        }
        try (Graph.Reference reference = this.graph.ref();){
            boolean bl = this.unsafeNativeHandle == operation.unsafeNativeHandle;
            return bl;
        }
    }

    public final String toString() {
        return String.format("<%s '%s'>", this.type(), this.name());
    }

    public final int inputListLength(String name) {
        try (Graph.Reference reference = this.graph.ref();){
            int n2 = Operation.inputListLength(this.unsafeNativeHandle, name);
            return n2;
        }
    }

    final long getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    final long[] shape(int output) {
        try (Graph.Reference reference = this.graph.ref();){
            long[] lArray = Operation.shape(reference.nativeHandle(), this.unsafeNativeHandle, output);
            return lArray;
        }
    }

    final DataType dtype(int output) {
        try (Graph.Reference reference = this.graph.ref();){
            DataType dataType = DataType.fromC(Operation.dtype(reference.nativeHandle(), this.unsafeNativeHandle, output));
            return dataType;
        }
    }

    private static native String name(long var0);

    private static native String type(long var0);

    private static native int numOutputs(long var0);

    private static native int outputListLength(long var0, String var2);

    private static native int inputListLength(long var0, String var2);

    private static native long[] shape(long var0, long var2, int var4);

    private static native int dtype(long var0, long var2, int var4);
}

