/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.TensorFlow;

public final class Server
implements AutoCloseable {
    private long nativeHandle;
    private int numJoining;

    public Server(byte[] serverDef) {
        this.nativeHandle = Server.allocate(serverDef);
    }

    public final synchronized void start() {
        Server.start(this.nativeHandle);
    }

    public final synchronized void stop() {
        Server.stop(this.nativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join() {
        long l2;
        Server server = this;
        synchronized (server) {
            l2 = this.nativeHandle;
            if (l2 != 0L) {
                ++this.numJoining;
            }
        }
        try {
            Server.join(l2);
        }
        finally {
            server = this;
            synchronized (server) {
                if (l2 != 0L) {
                    --this.numJoining;
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public final synchronized void close() throws InterruptedException {
        this.stop();
        while (this.numJoining > 0) {
            this.wait();
        }
        Server.delete(this.nativeHandle);
        this.nativeHandle = 0L;
    }

    private static native long allocate(byte[] var0);

    private static native void start(long var0);

    private static native void stop(long var0);

    private static native void join(long var0);

    private static native void delete(long var0);

    static {
        TensorFlow.init();
    }
}

