/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Arrays;

public final class Shape {
    private long[] shape;

    public static Shape unknown() {
        return new Shape(null);
    }

    public static Shape scalar() {
        return new Shape(new long[0]);
    }

    public static Shape make(long firstDimensionSize, long ... otherDimensionSizes) {
        long[] lArray = new long[otherDimensionSizes.length + 1];
        long[] lArray2 = lArray;
        lArray[0] = firstDimensionSize;
        System.arraycopy(otherDimensionSizes, 0, lArray2, 1, otherDimensionSizes.length);
        return new Shape(lArray2);
    }

    public final int numDimensions() {
        if (this.shape == null) {
            return -1;
        }
        return this.shape.length;
    }

    public final long size(int i2) {
        return this.shape[i2];
    }

    public final int hashCode() {
        return Arrays.hashCode(this.shape);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Shape && Arrays.equals(this.shape, ((Shape)obj).shape)) {
            return !this.hasUnknownDimension();
        }
        return super.equals(obj);
    }

    public final String toString() {
        if (this.shape == null) {
            return "<unknown>";
        }
        return Arrays.toString(this.shape).replace("-1", "?");
    }

    Shape(long[] shape) {
        this.shape = shape;
    }

    final long[] asArray() {
        return this.shape;
    }

    private boolean hasUnknownDimension() {
        if (this.shape == null) {
            return true;
        }
        long[] lArray = this.shape;
        int n2 = this.shape.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if (l2 != -1L) continue;
            return true;
        }
        return false;
    }
}

