/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AddManySparseToTensorsMap
extends PrimitiveOp
implements Operand<Long> {
    private Output<Long> sparseHandles;

    public static <T> AddManySparseToTensorsMap create(Scope scope, Operand<Long> sparseIndices, Operand<T> sparseValues, Operand<Long> sparseShape, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("AddManySparseToTensorsMap", scope.makeOpName("AddManySparseToTensorsMap"));
        operationBuilder.addInput(sparseIndices.asOutput());
        operationBuilder.addInput(sparseValues.asOutput());
        operationBuilder.addInput(sparseShape.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName == null) continue;
                operationBuilder.setAttr("shared_name", options2.sharedName);
            }
        }
        return new AddManySparseToTensorsMap(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public final Output<Long> sparseHandles() {
        return this.sparseHandles;
    }

    @Override
    public final Output<Long> asOutput() {
        return this.sparseHandles;
    }

    private AddManySparseToTensorsMap(Operation operation) {
        super(operation);
        this.sparseHandles = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

