/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static BatchDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> batchSize, List<Class<?>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BatchDataset", scope.makeOpName("BatchDataset"));
        operationBuilder.addInput(inputDataset.asOutput());
        operationBuilder.addInput(batchSize.asOutput());
        DataType[] dataTypeArray = new DataType[outputTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(outputTypes.get(i2));
        }
        operationBuilder.setAttr("output_types", dataTypeArray);
        Shape[] shapeArray = new Shape[outputShapes.size()];
        for (int i3 = 0; i3 < shapeArray.length; ++i3) {
            shapeArray[i3] = outputShapes.get(i3);
        }
        operationBuilder.setAttr("output_shapes", shapeArray);
        return new BatchDataset(operationBuilder.build());
    }

    public final Output<?> handle() {
        return this.handle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.handle;
    }

    private BatchDataset(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
    }
}

