/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchMatrixInverse<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> BatchMatrixInverse<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BatchMatrixInverse", scope.makeOpName("BatchMatrixInverse"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.adjoint == null) continue;
                operationBuilder.setAttr("adjoint", options2.adjoint);
            }
        }
        return new BatchMatrixInverse<T>(operationBuilder.build());
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private BatchMatrixInverse(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean adjoint;

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }

        private Options() {
        }
    }
}

