/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesCalculateBestGainsPerFeature
extends PrimitiveOp {
    private List<Output<Integer>> nodeIdsList;
    private List<Output<Float>> gainsList;
    private List<Output<Integer>> thresholdsList;
    private List<Output<Float>> leftNodeContribsList;
    private List<Output<Float>> rightNodeContribsList;

    public static BoostedTreesCalculateBestGainsPerFeature create(Scope scope, Operand<Integer> nodeIdRange, Iterable<Operand<Float>> statsSummaryList, Operand<Float> l1, Operand<Float> l2, Operand<Float> treeComplexity, Operand<Float> minNodeWeight, Long maxSplits) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BoostedTreesCalculateBestGainsPerFeature", scope.makeOpName("BoostedTreesCalculateBestGainsPerFeature"));
        operationBuilder.addInput(nodeIdRange.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(statsSummaryList));
        operationBuilder.addInput(l1.asOutput());
        operationBuilder.addInput(l2.asOutput());
        operationBuilder.addInput(treeComplexity.asOutput());
        operationBuilder.addInput(minNodeWeight.asOutput());
        operationBuilder.setAttr("max_splits", maxSplits);
        return new BoostedTreesCalculateBestGainsPerFeature(operationBuilder.build());
    }

    public final List<Output<Integer>> nodeIdsList() {
        return this.nodeIdsList;
    }

    public final List<Output<Float>> gainsList() {
        return this.gainsList;
    }

    public final List<Output<Integer>> thresholdsList() {
        return this.thresholdsList;
    }

    public final List<Output<Float>> leftNodeContribsList() {
        return this.leftNodeContribsList;
    }

    public final List<Output<Float>> rightNodeContribsList() {
        return this.rightNodeContribsList;
    }

    private BoostedTreesCalculateBestGainsPerFeature(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("node_ids_list");
        this.nodeIdsList = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("gains_list");
        this.gainsList = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("thresholds_list");
        this.thresholdsList = Arrays.asList(operation.outputList(n3 += n4, n5));
        int n6 = operation.outputListLength("left_node_contribs_list");
        this.leftNodeContribsList = Arrays.asList(operation.outputList(n3 += n5, n6));
        int n7 = operation.outputListLength("right_node_contribs_list");
        this.rightNodeContribsList = Arrays.asList(operation.outputList(n3 += n6, n7));
    }
}

