/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CTCGreedyDecoder
extends PrimitiveOp {
    private Output<Long> decodedIndices;
    private Output<Long> decodedValues;
    private Output<Long> decodedShape;
    private Output<Float> logProbability;

    public static CTCGreedyDecoder create(Scope scope, Operand<Float> inputs, Operand<Integer> sequenceLength, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CTCGreedyDecoder", scope.makeOpName("CTCGreedyDecoder"));
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.mergeRepeated == null) continue;
                operationBuilder.setAttr("merge_repeated", options2.mergeRepeated);
            }
        }
        return new CTCGreedyDecoder(operationBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public final Output<Long> decodedIndices() {
        return this.decodedIndices;
    }

    public final Output<Long> decodedValues() {
        return this.decodedValues;
    }

    public final Output<Long> decodedShape() {
        return this.decodedShape;
    }

    public final Output<Float> logProbability() {
        return this.logProbability;
    }

    private CTCGreedyDecoder(Operation operation) {
        super(operation);
        this.decodedIndices = operation.output(0);
        this.decodedValues = operation.output(1);
        this.decodedShape = operation.output(2);
        this.logProbability = operation.output(3);
    }

    public static class Options {
        private Boolean mergeRepeated;

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        private Options() {
        }
    }
}

