/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Constant<T>
extends PrimitiveOp
implements Operand<T> {
    private final Output<T> output;

    public static Constant<Integer> create(Scope scope, int data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[] data) {
        return Constant.create(scope, (Object)data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, long[] shape, IntBuffer data) {
        Tensor<Integer> tensor = Tensor.create(shape, data);
        Throwable throwable = null;
        try {
            Constant<Integer> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static Constant<Float> create(Scope scope, float data) {
        return Constant.create(scope, Float.valueOf(data), Float.class);
    }

    public static Constant<Float> create(Scope scope, float[] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, long[] shape, FloatBuffer data) {
        Tensor<Float> tensor = Tensor.create(shape, data);
        Throwable throwable = null;
        try {
            Constant<Float> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static Constant<Double> create(Scope scope, double data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, long[] shape, DoubleBuffer data) {
        Tensor<Double> tensor = Tensor.create(shape, data);
        Throwable throwable = null;
        try {
            Constant<Double> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static Constant<Long> create(Scope scope, long data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[] data) {
        return Constant.create(scope, (Object)data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[] shape, LongBuffer data) {
        Tensor<Long> tensor = Tensor.create(shape, data);
        Throwable throwable = null;
        try {
            Constant<Long> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static Constant<Boolean> create(Scope scope, boolean data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<String> create(Scope scope, String data) {
        return Constant.create(scope, data, StandardCharsets.UTF_8);
    }

    public static Constant<String> create(Scope scope, String data, Charset charset) {
        Tensor<String> tensor = Tensor.create((Object)data.getBytes(charset), String.class);
        Throwable throwable = null;
        try {
            Constant<String> constant = Constant.createWithTensor(scope, Tensor.create((Object)data.getBytes(charset), String.class));
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static Constant<String> create(Scope scope, byte[] data) {
        return Constant.create(scope, (Object)data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static <T> Constant<T> create(Scope scope, Class<T> type, long[] shape, ByteBuffer data) {
        Tensor<T> tensor = Tensor.create(type, shape, data);
        Throwable throwable = null;
        try {
            Constant<T> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public static <T> Constant<T> create(Scope scope, Object object, Class<T> type) {
        Tensor<T> tensor = Tensor.create(object, type);
        Throwable throwable = null;
        try {
            Constant<T> constant = Constant.createWithTensor(scope, tensor);
            if (tensor != null) {
                tensor.close();
            }
            return constant;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (tensor != null) {
                    if (throwable != null) {
                        try {
                            tensor.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tensor.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    private static <T> Constant<T> createWithTensor(Scope scope, Tensor<T> value) {
        return new Constant<T>(scope.graph().opBuilder("Const", scope.makeOpName("Const")).setAttr("value", value).setAttr("dtype", value.dataType()).build());
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Constant(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

