/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class HashTable
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> tableHandle;

    public static <T, U> HashTable create(Scope scope, Class<T> keyDtype, Class<U> valueDtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("HashTableV2", scope.makeOpName("HashTable"));
        operationBuilder.setAttr("key_dtype", DataType.fromClass(keyDtype));
        operationBuilder.setAttr("value_dtype", DataType.fromClass(valueDtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.useNodeNameSharing == null) continue;
                operationBuilder.setAttr("use_node_name_sharing", options2.useNodeNameSharing);
            }
        }
        return new HashTable(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public final Output<?> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.tableHandle;
    }

    private HashTable(Operation operation) {
        super(operation);
        this.tableHandle = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }

        private Options() {
        }
    }
}

