/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MultiDeviceIterator
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static MultiDeviceIterator create(Scope scope, List<String> devices, String sharedName, String container, List<Class<?>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MultiDeviceIterator", scope.makeOpName("MultiDeviceIterator"));
        String[] stringArray = new String[devices.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = devices.get(i2);
        }
        operationBuilder.setAttr("devices", stringArray);
        operationBuilder.setAttr("shared_name", sharedName);
        operationBuilder.setAttr("container", container);
        DataType[] dataTypeArray = new DataType[outputTypes.size()];
        for (int i3 = 0; i3 < dataTypeArray.length; ++i3) {
            dataTypeArray[i3] = DataType.fromClass(outputTypes.get(i3));
        }
        operationBuilder.setAttr("output_types", dataTypeArray);
        Shape[] shapeArray = new Shape[outputShapes.size()];
        for (int i4 = 0; i4 < shapeArray.length; ++i4) {
            shapeArray[i4] = outputShapes.get(i4);
        }
        operationBuilder.setAttr("output_shapes", shapeArray);
        return new MultiDeviceIterator(operationBuilder.build());
    }

    public final Output<?> handle() {
        return this.handle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.handle;
    }

    private MultiDeviceIterator(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
    }
}

