/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class NonMaxSuppression
extends PrimitiveOp
implements Operand<Integer> {
    private Output<Integer> selectedIndices;

    public static NonMaxSuppression create(Scope scope, Operand<Float> boxes, Operand<Float> scores, Operand<Integer> maxOutputSize, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("NonMaxSuppression", scope.makeOpName("NonMaxSuppression"));
        operationBuilder.addInput(boxes.asOutput());
        operationBuilder.addInput(scores.asOutput());
        operationBuilder.addInput(maxOutputSize.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.iouThreshold == null) continue;
                operationBuilder.setAttr("iou_threshold", options2.iouThreshold.floatValue());
            }
        }
        return new NonMaxSuppression(operationBuilder.build());
    }

    public static Options iouThreshold(Float iouThreshold) {
        return new Options().iouThreshold(iouThreshold);
    }

    public final Output<Integer> selectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public final Output<Integer> asOutput() {
        return this.selectedIndices;
    }

    private NonMaxSuppression(Operation operation) {
        super(operation);
        this.selectedIndices = operation.output(0);
    }

    public static class Options {
        private Float iouThreshold;

        public Options iouThreshold(Float iouThreshold) {
            this.iouThreshold = iouThreshold;
            return this;
        }

        private Options() {
        }
    }
}

