/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class PaddedBatchDatasetV2
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static PaddedBatchDatasetV2 create(Scope scope, Operand<?> inputDataset, Operand<Long> batchSize, Iterable<Operand<Long>> paddedShapes, Iterable<Operand<?>> paddingValues, Operand<Boolean> dropRemainder, List<Shape> outputShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("PaddedBatchDatasetV2", scope.makeOpName("PaddedBatchDatasetV2"));
        operationBuilder.addInput(inputDataset.asOutput());
        operationBuilder.addInput(batchSize.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(paddedShapes));
        operationBuilder.addInputList(Operands.asOutputs(paddingValues));
        operationBuilder.addInput(dropRemainder.asOutput());
        Shape[] shapeArray = new Shape[outputShapes.size()];
        for (int i2 = 0; i2 < shapeArray.length; ++i2) {
            shapeArray[i2] = outputShapes.get(i2);
        }
        operationBuilder.setAttr("output_shapes", shapeArray);
        return new PaddedBatchDatasetV2(operationBuilder.build());
    }

    public final Output<?> handle() {
        return this.handle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.handle;
    }

    private PaddedBatchDatasetV2(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
    }
}

